/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorController;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CollectorServlet
extends HttpServlet {
    private static final long serialVersionUID = -2070469677921953224L;
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private Pattern allowedAddrPattern;
    private transient CollectorServer collectorServer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Parameters.initialize(config.getServletContext());
        if (!Boolean.parseBoolean(Parameters.getParameter(Parameter.LOG))) {
            LOGGER.setLevel(Level.WARN);
        }
        LOGGER.info((Object)"initialization of the collector servlet of the monitoring");
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            this.allowedAddrPattern = Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        try {
            this.collectorServer = new CollectorServer();
        }
        catch (IOException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String application;
        long start;
        block7: {
            block6: {
                block5: {
                    start = System.currentTimeMillis();
                    if (this.isAddressAllowed(req)) {
                        resp.sendError(403, "Forbidden access");
                        return;
                    }
                    CollectorController collectorController = new CollectorController(this.collectorServer);
                    application = collectorController.getApplication(req, resp);
                    I18N.bindLocale(req.getLocale());
                    try {
                        if (application == null) {
                            CollectorController.writeOnlyAddApplication(resp);
                            Object var8_6 = null;
                            break block5;
                        }
                        if (!this.collectorServer.isApplicationDataAvailable(application)) {
                            resp.sendError(500, "Data unavailable for the application " + application);
                            break block6;
                        }
                        collectorController.doMonitoring(req, resp, application);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        I18N.unbindLocale();
                        if (!LOGGER.isDebugEnabled()) throw throwable;
                        LOGGER.debug((Object)("monitoring from " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " in " + (System.currentTimeMillis() - start) + "ms"));
                        throw throwable;
                    }
                }
                I18N.unbindLocale();
                if (!LOGGER.isDebugEnabled()) return;
                LOGGER.debug((Object)("monitoring from " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " in " + (System.currentTimeMillis() - start) + "ms"));
                return;
            }
            Object var8_7 = null;
            I18N.unbindLocale();
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug((Object)("monitoring from " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " in " + (System.currentTimeMillis() - start) + "ms"));
            return;
        }
        Object var8_8 = null;
        I18N.unbindLocale();
        if (!LOGGER.isDebugEnabled()) return;
        LOGGER.debug((Object)("monitoring from " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " in " + (System.currentTimeMillis() - start) + "ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block12: {
            block11: {
                block10: {
                    if (this.isAddressAllowed(req)) {
                        resp.sendError(403, "Forbidden access");
                        return;
                    }
                    String appName = req.getParameter("appName");
                    String appUrls = req.getParameter("appUrls");
                    I18N.bindLocale(req.getLocale());
                    CollectorController collectorController = new CollectorController(this.collectorServer);
                    try {
                        try {
                            if (appName == null || appUrls == null) {
                                this.writeMessage(req, resp, collectorController, I18N.getString("donnees_manquantes"));
                                Object var9_6 = null;
                                break block10;
                            }
                            if (!appUrls.startsWith("http://") && !appUrls.startsWith("https://")) {
                                this.writeMessage(req, resp, collectorController, I18N.getString("urls_format"));
                                break block11;
                            }
                            collectorController.addCollectorApplication(appName, appUrls);
                            LOGGER.info((Object)("monitored application added: " + appName));
                            LOGGER.info((Object)("urls of the monitored application: " + appUrls));
                            CollectorController.showAlertAndRedirectTo(resp, I18N.getFormattedString("application_ajoutee", appName), "?application=" + appName);
                            break block12;
                        }
                        catch (FileNotFoundException e) {
                            String message = I18N.getString("monitoring_configure");
                            LOGGER.warn((Object)message, (Throwable)e);
                            this.writeMessage(req, resp, collectorController, message + '\n' + e.toString());
                            Object var9_9 = null;
                            I18N.unbindLocale();
                            return;
                        }
                        catch (StreamCorruptedException e) {
                            String message = I18N.getFormattedString("reponse_non_comprise", appUrls);
                            LOGGER.warn((Object)message, (Throwable)e);
                            this.writeMessage(req, resp, collectorController, message + '\n' + e.toString());
                            Object var9_10 = null;
                            I18N.unbindLocale();
                            return;
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)e.toString(), (Throwable)e);
                            this.writeMessage(req, resp, collectorController, e.toString());
                            Object var9_11 = null;
                            I18N.unbindLocale();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        I18N.unbindLocale();
                        throw throwable;
                    }
                }
                I18N.unbindLocale();
                return;
            }
            Object var9_7 = null;
            I18N.unbindLocale();
            return;
        }
        Object var9_8 = null;
        I18N.unbindLocale();
    }

    private void writeMessage(HttpServletRequest req, HttpServletResponse resp, CollectorController collectorController, String message) throws IOException {
        collectorController.writeMessage(req, resp, collectorController.getApplication(req, resp), message);
    }

    private boolean isAddressAllowed(HttpServletRequest req) {
        return this.allowedAddrPattern != null && !this.allowedAddrPattern.matcher(req.getRemoteAddr()).matches();
    }

    public void destroy() {
        LOGGER.info((Object)"collector servlet stopping");
        if (this.collectorServer != null) {
            this.collectorServer.stop();
        }
        Collector.stopJRobin();
        LOGGER.info((Object)"collector servlet stopped");
        super.destroy();
    }
}

