/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Set;
import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameters;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.jndi.JndiObjectFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringDataSourceBeanPostProcessor
implements BeanPostProcessor {
    private Set<String> excludedDatasources;

    public void setExcludedDatasources(Set<String> excludedDatasources) {
        this.excludedDatasources = excludedDatasources;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) {
        if (this.excludedDatasources != null && this.excludedDatasources.contains(beanName)) {
            LOG.debug("Spring datasource excluded: " + beanName);
            return bean;
        }
        if (bean instanceof DataSource && !Parameters.isNoDatabase()) {
            DataSource dataSource = (DataSource)bean;
            JdbcWrapper.registerSpringDataSource(beanName, dataSource);
            DataSource result = JdbcWrapper.SINGLETON.createDataSourceProxy(beanName, dataSource);
            LOG.debug("Spring datasource wrapped: " + beanName);
            return result;
        }
        if (bean instanceof JndiObjectFactoryBean && !Parameters.isNoDatabase()) {
            InvocationHandler invocationHandler = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result = method.invoke(bean, args);
                    if (result instanceof DataSource) {
                        result = JdbcWrapper.SINGLETON.createDataSourceProxy(beanName, (DataSource)result);
                    }
                    return result;
                }
            };
            Object result = JdbcWrapper.createProxy(bean, invocationHandler);
            LOG.debug("Spring JNDI factory wrapped: " + beanName);
            return result;
        }
        return bean;
    }
}

