/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfHeapHistogramReport;
import net.bull.javamelody.PdfSessionInformationsReport;
import net.bull.javamelody.SessionInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfOtherReport {
    private final Document document;
    private final PdfDocumentFactory pdfDocumentFactory;

    PdfOtherReport(String application, OutputStream output) throws IOException {
        assert (output != null);
        try {
            this.pdfDocumentFactory = new PdfDocumentFactory(application, output);
            this.document = this.pdfDocumentFactory.createDocument();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException(e);
        }
    }

    void writeSessionInformations(List<SessionInformations> sessionsInformations) throws IOException {
        try {
            this.document.open();
            this.addParagraph(PdfOtherReport.getI18nString("Sessions"), "system-users.png");
            new PdfSessionInformationsReport(sessionsInformations, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException(e);
        }
        this.document.close();
    }

    void writeHeapHistogram(HeapHistogram heapHistogram) throws IOException {
        try {
            this.document.open();
            this.addParagraph(I18N.getFormattedString("heap_histo_du", I18N.createDateAndTimeFormat().format(heapHistogram.getTime())), "memory.png");
            new PdfHeapHistogramReport(heapHistogram, this.document).toPdf();
        }
        catch (DocumentException e) {
            throw PdfOtherReport.createIOException(e);
        }
        this.document.close();
    }

    private static IOException createIOException(DocumentException e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    private void addParagraph(String paragraphTitle, String iconName) throws DocumentException, IOException {
        this.add(this.pdfDocumentFactory.createParagraphElement(paragraphTitle, iconName));
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private void add(Element element) throws DocumentException {
        this.document.add(element);
    }
}

