/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import net.bull.javamelody.LOG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MBeans {
    private final MBeanServer mbeanServer = MBeans.getMBeanServer();

    MBeans() {
    }

    Set<ObjectName> getThreadPools() throws MalformedObjectNameException {
        return this.mbeanServer.queryNames(new ObjectName("*:type=ThreadPool,*"), null);
    }

    Set<ObjectName> getGlobalRequestProcessors() throws MalformedObjectNameException {
        return this.mbeanServer.queryNames(new ObjectName("*:type=GlobalRequestProcessor,*"), null);
    }

    Object getAttribute(ObjectName name, String attribute) throws JMException {
        return this.mbeanServer.getAttribute(name, attribute);
    }

    private static void initJRockitMBeansIfNeeded() {
        if (System.getProperty("java.vendor").contains("BEA")) {
            try {
                try {
                    MBeans.getMBeanServer().getMBeanInfo(new ObjectName("bea.jrockit.management:type=JRockitConsole"));
                }
                catch (InstanceNotFoundException e1) {
                    MBeans.getMBeanServer().createMBean("bea.jrockit.management.JRockitConsole", null);
                    LOG.debug("JRockit MBeans initialized");
                }
            }
            catch (JMException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    Map<String, Map<String, List<ObjectName>>> getMapObjectNamesByDomainAndFirstProperty() {
        MBeans.initJRockitMBeansIfNeeded();
        TreeMap<String, Map<String, List<ObjectName>>> mapObjectNamesByDomainAndFirstProperty = new TreeMap<String, Map<String, List<ObjectName>>>();
        Set<ObjectName> names = this.mbeanServer.queryNames(null, null);
        for (ObjectName name : names) {
            String keyPropertyListString;
            int indexOf;
            String firstPropertyValue;
            ArrayList<ObjectName> objectNames;
            TreeMap<String, ArrayList<ObjectName>> mapObjectNamesByFirstProperty = (TreeMap<String, ArrayList<ObjectName>>)mapObjectNamesByDomainAndFirstProperty.get(name.getDomain());
            if (mapObjectNamesByFirstProperty == null) {
                mapObjectNamesByFirstProperty = new TreeMap<String, ArrayList<ObjectName>>();
                mapObjectNamesByDomainAndFirstProperty.put(name.getDomain(), mapObjectNamesByFirstProperty);
            }
            if ((objectNames = (ArrayList<ObjectName>)mapObjectNamesByFirstProperty.get(firstPropertyValue = (indexOf = (keyPropertyListString = name.getKeyPropertyListString()).indexOf(61)) == -1 ? null : name.getKeyProperty(keyPropertyListString.substring(0, indexOf)))) == null) {
                objectNames = new ArrayList<ObjectName>();
                mapObjectNamesByFirstProperty.put(firstPropertyValue, objectNames);
            }
            objectNames.add(name);
        }
        return mapObjectNamesByDomainAndFirstProperty;
    }

    MBeanInfo getMBeanInfo(ObjectName name) throws JMException {
        return this.mbeanServer.getMBeanInfo(name);
    }

    Map<String, Object> getAttributes(ObjectName name, MBeanAttributeInfo[] attributeInfos) throws JMException {
        ArrayList<String> attributeNames = new ArrayList<String>(attributeInfos.length);
        for (MBeanAttributeInfo attribute : attributeInfos) {
            if (!attribute.isReadable() || "password".equalsIgnoreCase(attribute.getName())) continue;
            attributeNames.add(attribute.getName());
        }
        String[] attributeNamesArray = attributeNames.toArray(new String[attributeNames.size()]);
        List<Attribute> attributes = this.mbeanServer.getAttributes(name, attributeNamesArray).asList();
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Attribute attribute : attributes) {
            Object value = this.convertValueIfNeeded(attribute.getValue());
            result.put(attribute.getName(), value);
        }
        return result;
    }

    private Object convertValueIfNeeded(Object value) {
        if (value instanceof CompositeData) {
            CompositeData data = (CompositeData)value;
            TreeMap<String, Object> values = new TreeMap<String, Object>();
            for (String key : data.getCompositeType().keySet()) {
                values.put(key, this.convertValueIfNeeded(data.get(key)));
            }
            return values;
        }
        if (value instanceof CompositeData[]) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (CompositeData data : (CompositeData[])value) {
                list.add(this.convertValueIfNeeded(data));
            }
            return list;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof TabularData) {
            TabularData tabularData = (TabularData)value;
            return this.convertValueIfNeeded(tabularData.values());
        }
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object data : (Collection)value) {
                list.add(this.convertValueIfNeeded(data));
            }
            return list;
        }
        return MBeans.convertJRockitValueIfNeeded(value);
    }

    private static Object convertJRockitValueIfNeeded(Object value) {
        if (value instanceof double[]) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (double data : (double[])value) {
                list.add(data);
            }
            return list;
        }
        if (value instanceof int[]) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int data : (int[])value) {
                list.add(data);
            }
            return list;
        }
        return value;
    }

    static String getConvertedAttributes(String jmxValueParameter) {
        MBeans.initJRockitMBeansIfNeeded();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String mbeansAttribute : jmxValueParameter.split("[|]")) {
            int lastIndexOfPoint = mbeansAttribute.lastIndexOf(46);
            if (lastIndexOfPoint <= 0) {
                throw new IllegalArgumentException(mbeansAttribute);
            }
            String name = mbeansAttribute.substring(0, lastIndexOfPoint);
            String attribute = mbeansAttribute.substring(lastIndexOfPoint + 1);
            if ("password".equalsIgnoreCase(attribute)) {
                throw new IllegalArgumentException(name + '.' + attribute);
            }
            if (first) {
                first = false;
            } else {
                sb.append('|');
            }
            try {
                MBeans mbeans = new MBeans();
                Object jmxValue = mbeans.convertValueIfNeeded(mbeans.getAttribute(new ObjectName(name), attribute));
                sb.append(jmxValue);
            }
            catch (JMException e) {
                throw new IllegalArgumentException(name + '.' + attribute, e);
            }
        }
        return sb.toString();
    }

    String getAttributeDescription(String name, MBeanAttributeInfo[] attributeInfos) {
        for (MBeanAttributeInfo attributeInfo : attributeInfos) {
            if (!name.equals(attributeInfo.getName())) continue;
            return attributeInfo.getDescription();
        }
        return null;
    }

    private static MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

