/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestAggregation;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HtmlCounterErrorReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Period;
import net.bull.javamelody.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlCounterReport {
    private final Counter counter;
    private final Range range;
    private final Writer writer;
    private final CounterRequestAggregation counterRequestAggregation;
    private final HtmlCounterRequestGraphReport htmlCounterRequestGraphReport;
    private final DecimalFormat systemErrorFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();

    HtmlCounterReport(Counter counter, Range range, Writer writer) {
        assert (counter != null);
        assert (range != null);
        assert (writer != null);
        this.counter = counter;
        this.range = range;
        this.writer = writer;
        this.counterRequestAggregation = new CounterRequestAggregation(counter);
        this.htmlCounterRequestGraphReport = new HtmlCounterRequestGraphReport(range, writer);
    }

    void toHtml() throws IOException {
        List<CounterRequest> requests = this.counterRequestAggregation.getRequests();
        if (requests.isEmpty()) {
            this.writeNoRequests();
            return;
        }
        String counterName = this.counter.getName();
        CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
        if (this.isErrorAndNotJobCounter()) {
            assert (!requests.isEmpty());
            List<CounterRequest> summaryRequest = Collections.singletonList(requests.get(0));
            this.writeRequests(counterName, this.counter.getChildCounterName(), summaryRequest, false, true, false);
        } else {
            List<CounterRequest> summaryRequests = Arrays.asList(globalRequest, this.counterRequestAggregation.getWarningRequest(), this.counterRequestAggregation.getSevereRequest());
            this.writeRequests(globalRequest.getName(), this.counter.getChildCounterName(), summaryRequests, false, false, false);
        }
        long deltaMillis = Math.max(System.currentTimeMillis() - this.counter.getStartDate().getTime(), 1L);
        long hitsParMinute = 60000L * globalRequest.getHits() / deltaMillis;
        this.writeln("<div align='right'>");
        String nbKey = this.isJobCounter() ? "nb_jobs" : (this.isErrorCounter() ? "nb_erreurs" : "nb_requetes");
        this.writeln(I18N.getFormattedString(nbKey, this.integerFormat.format(hitsParMinute), this.integerFormat.format(requests.size())));
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        if (this.counter.isBusinessFacadeCounter()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?part=counterSummaryPerClass&amp;counter=" + counterName + "' class='noPrint'>#Resume_par_classe#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeShowHideLink("details" + counterName, "#Details#");
        if (this.isErrorCounter()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeShowHideLink("logs" + counterName, "#Dernieres_erreurs#");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        if (this.range.getPeriod() == Period.TOUT) {
            this.writeln("<a href='?action=clear_counter&amp;counter=" + counterName + "' title='" + I18N.getFormattedString("Vider_stats", counterName) + '\'');
            this.writeln("class='noPrint' onclick=\"javascript:return confirm('" + I18N.javascriptEncode(I18N.getFormattedString("confirm_vider_stats", counterName)) + "');\">#Reinitialiser#</a>");
        }
        this.writeln("</div>");
        this.writeln("<div id='details" + counterName + "' style='display: none;'>");
        this.writeRequests(counterName, this.counter.getChildCounterName(), requests, HtmlCounterReport.isRequestGraphDisplayed(this.counter), true, false);
        this.writeln("</div>");
        if (this.isErrorCounter()) {
            this.writeln("<div id='logs" + counterName + "' style='display: none;'>");
            new HtmlCounterErrorReport(this.counter, this.writer).toHtml();
            this.writeln("</div>");
        }
    }

    private void writeNoRequests() throws IOException {
        if (this.isJobCounter()) {
            this.writeln("#Aucun_job#");
        } else if (this.isErrorCounter()) {
            this.writeln("#Aucune_erreur#");
        } else {
            this.writeln("#Aucune_requete#");
        }
    }

    private boolean isErrorCounter() {
        return this.counter.isErrorCounter();
    }

    private boolean isJobCounter() {
        return this.counter.isJobCounter();
    }

    private boolean isErrorAndNotJobCounter() {
        return this.isErrorCounter() && !this.isJobCounter();
    }

    static boolean isRequestGraphDisplayed(Counter parentCounter) {
        return (!parentCounter.isErrorCounter() || parentCounter.isJobCounter()) && !parentCounter.isJspOrStrutsCounter();
    }

    void writeRequestsAggregatedOrFilteredByClassName(String requestId) throws IOException {
        List<CounterRequest> requestList;
        List<CounterRequest> requestsAggregatedByClassName = this.counterRequestAggregation.getRequestsAggregatedByClassName();
        if (requestId == null) {
            requestList = requestsAggregatedByClassName;
        } else {
            requestList = new ArrayList<CounterRequest>();
            for (CounterRequest requestAggregated : requestsAggregatedByClassName) {
                if (!requestId.equals(requestAggregated.getId())) continue;
                String className = requestAggregated.getName();
                requestList.addAll(this.counterRequestAggregation.getRequestsFilteredByClassName(className));
                break;
            }
        }
        boolean includeSummaryPerClassLink = requestId == null;
        boolean includeDetailLink = !includeSummaryPerClassLink;
        this.writeRequests(this.counter.getName(), this.counter.getChildCounterName(), requestList, includeDetailLink, includeDetailLink, includeSummaryPerClassLink);
    }

    private void writeRequests(String tableName, String childCounterName, List<CounterRequest> requestList, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        assert (requestList != null);
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='" + tableName + "'>");
        this.writeTableHead(childCounterName);
        this.writeln("<tbody>");
        boolean odd = false;
        for (CounterRequest request : requestList) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeRequest(request, includeGraph, includeDetailLink, includeSummaryPerClassLink);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
    }

    private void writeTableHead(String childCounterName) throws IOException {
        if (this.isJobCounter()) {
            this.write("<thead><tr><th>#Job#</th>");
        } else if (this.isErrorCounter()) {
            this.write("<thead><tr><th>#Erreur#</th>");
        } else {
            this.write("<thead><tr><th>#Requete#</th>");
        }
        if (this.counterRequestAggregation.isTimesDisplayed()) {
            this.write("<th class='sorttable_numeric'>#temps_cumule#</th>");
            this.write("<th class='sorttable_numeric'>#Hits#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_moyen#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_max#</th>");
            this.write("<th class='sorttable_numeric'>#Ecart_type#</th>");
        } else {
            this.write("<th class='sorttable_numeric'>#Hits#</th>");
        }
        if (this.counterRequestAggregation.isCpuTimesDisplayed()) {
            this.write("<th class='sorttable_numeric'>#temps_cpu_cumule#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_cpu_moyen#</th>");
        }
        if (!this.isErrorAndNotJobCounter()) {
            this.write("<th class='sorttable_numeric'>#erreur_systeme#</th>");
        }
        if (this.counterRequestAggregation.isResponseSizeDisplayed()) {
            this.write("<th class='sorttable_numeric'>#Taille_moyenne#</th>");
        }
        if (this.counterRequestAggregation.isChildHitsDisplayed()) {
            this.write("<th class='sorttable_numeric'>" + I18N.getFormattedString("hits_fils_moyens", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + I18N.getFormattedString("temps_fils_moyen", childCounterName) + "</th>");
        }
        this.writeln("</tr></thead>");
    }

    private void writeRequest(CounterRequest request, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        String nextColumn = "</td> <td align='right'>";
        this.write("<td>");
        this.writeRequestName(request.getId(), request.getName(), includeGraph, includeDetailLink, includeSummaryPerClassLink);
        CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
        if (this.counterRequestAggregation.isTimesDisplayed()) {
            this.write("</td> <td align='right'>");
            this.writePercentage(request.getDurationsSum(), globalRequest.getDurationsSum());
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getHits()));
            this.write("</td> <td align='right'>");
            int mean = request.getMean();
            this.write("<span class='");
            this.write(this.getSlaHtmlClass(mean));
            this.write("'>");
            this.write(this.integerFormat.format(mean));
            this.write("</span>");
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getMaximum()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getStandardDeviation()));
        } else {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getHits()));
        }
        if (this.counterRequestAggregation.isCpuTimesDisplayed()) {
            this.write("</td> <td align='right'>");
            this.writePercentage(request.getCpuTimeSum(), globalRequest.getCpuTimeSum());
            this.write("</td> <td align='right'>");
            int cpuTimeMean = request.getCpuTimeMean();
            this.write("<span class='");
            this.write(this.getSlaHtmlClass(cpuTimeMean));
            this.write("'>");
            this.write(this.integerFormat.format(cpuTimeMean));
            this.write("</span>");
        }
        if (!this.isErrorAndNotJobCounter()) {
            this.write("</td> <td align='right'>");
            this.write(this.systemErrorFormat.format(request.getSystemErrorPercentage()));
        }
        if (this.counterRequestAggregation.isResponseSizeDisplayed()) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getResponseSizeMean() / 1024));
        }
        if (this.counterRequestAggregation.isChildHitsDisplayed()) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getChildHitsMean()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getChildDurationsMean()));
        }
        this.write("</td>");
    }

    void writeRequestName(String requestId, String requestName, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        if (includeGraph) {
            assert (includeDetailLink);
            assert (!includeSummaryPerClassLink);
            this.htmlCounterRequestGraphReport.writeRequestGraph(requestId, requestName);
        } else if (includeDetailLink) {
            assert (!includeSummaryPerClassLink);
            this.write("<a href='?part=graph&amp;graph=");
            this.write(requestId);
            this.write("'>");
            this.writer.write(HtmlCounterReport.htmlEncode(requestName));
            this.write("</a>");
        } else if (includeSummaryPerClassLink) {
            this.write("<a href='?part=counterSummaryPerClass&amp;counter=");
            this.write(this.counter.getName());
            this.write("&amp;graph=");
            this.write(requestId);
            this.write("'>");
            this.writer.write(HtmlCounterReport.htmlEncode(requestName));
            this.write("</a> ");
        } else {
            this.writer.write(HtmlCounterReport.htmlEncode(requestName));
        }
    }

    String getSlaHtmlClass(int mean) {
        String color = mean < this.counterRequestAggregation.getWarningThreshold() || mean == 0 ? "info" : (mean < this.counterRequestAggregation.getSevereThreshold() ? "warning" : "severe");
        return color;
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, false);
    }

    private void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writeln("<a href=\"javascript:showHide('" + idToShow + "');\" class='noPrint'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    private void writePercentage(long dividende, long diviseur) throws IOException {
        if (diviseur == 0L) {
            this.write("0");
        } else {
            this.write(this.integerFormat.format(100L * dividende / diviseur));
        }
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HtmlCounterRequestGraphReport {
        private static final String SCRIPT_BEGIN = "<script type='text/javascript'>";
        private static final String SCRIPT_END = "</script>";
        private static int uniqueByPageAndGraphSequence;
        private final Range range;
        private final Writer writer;
        private final DecimalFormat systemErrorFormat = I18N.createPercentFormat();
        private final DecimalFormat nbExecutionsFormat = I18N.createPercentFormat();
        private final DecimalFormat integerFormat = I18N.createIntegerFormat();
        private List<Counter> counters;
        private Map<String, CounterRequest> requestsById;

        HtmlCounterRequestGraphReport(Range range, Writer writer) {
            assert (range != null);
            assert (writer != null);
            this.range = range;
            this.writer = writer;
        }

        void writeRequestGraph(String requestId, String requestName) throws IOException {
            this.write("<a class='tooltip' href='?part=graph&amp;graph=");
            this.write(requestId);
            this.write("'");
            this.write(" onmouseover=\"document.getElementById('");
            String id = "id" + ++uniqueByPageAndGraphSequence;
            this.write(id);
            this.write("').src='?graph=");
            this.write(requestId);
            this.write("&amp;width=100&amp;height=50'; this.onmouseover=null;\" >");
            this.write("<em><img src='?resource=db.png' id='");
            this.write(id);
            this.write("' alt='graph'/></em>");
            this.writer.write(HtmlCounterRequestGraphReport.htmlEncode(requestName));
            this.write("</a>");
        }

        void writeRequestAndGraphDetail(Collector collector, String graphName) throws IOException {
            this.counters = collector.getRangeCountersToBeDisplayed(this.range);
            this.requestsById = this.mapAllRequestsById();
            CounterRequest request = this.requestsById.get(graphName);
            if (request != null) {
                this.writeRequest(request);
                if (graphName.startsWith(JdbcWrapper.SINGLETON.getSqlCounter().getName())) {
                    this.writeSqlRequestExplainPlan(request.getName());
                }
            }
            if (request == null || this.getCounterByRequestId(request) != null && HtmlCounterReport.isRequestGraphDisplayed(this.getCounterByRequestId(request))) {
                this.writeln("<div id='track' class='noPrint'>");
                this.writeln("<div class='selected' id='handle'>");
                this.writeln("<img src='?resource=scaler_slider.gif' alt=''/>");
                this.writeln("</div></div>");
                this.writeln("<div align='center'><img class='synth\u00e8se' id='img' src='?width=960&amp;height=400&amp;graph=" + graphName + "' alt='zoom'/></div>");
                this.writeln("<div align='right'><a href='?part=lastValue&amp;graph=" + graphName + "' title=\"#Lien_derniere_valeur#\">_</a></div>");
                this.writeGraphDetailScript(graphName);
            }
            if (request != null && request.getStackTrace() != null) {
                this.writeln("<blockquote><blockquote><b>Stack-trace</b><br/><font size='-1'>");
                this.writer.write(HtmlCounterRequestGraphReport.htmlEncode(request.getStackTrace()).replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"));
                this.writeln("</font></blockquote></blockquote>");
            }
        }

        private void writeSqlRequestExplainPlan(String sqlRequest) throws IOException {
            try {
                String explainPlan = DatabaseInformations.explainPlanFor(sqlRequest);
                if (explainPlan != null) {
                    this.writeln("<b>#Plan_d_execution#</b>");
                    this.writeln("<div class='explainPlan'>");
                    this.writer.write(explainPlan.replace(" ", "&nbsp;").replace("\n", "<br/>"));
                    this.writeln("</div><hr/>");
                }
            }
            catch (Exception e) {
                this.writeln("<b>#Plan_d_execution#</b> ");
                this.writeln(e.toString());
                this.writeln("<br/>");
            }
        }

        void writeRequestUsages(Collector collector, String requestId) throws IOException {
            assert (requestId != null);
            this.counters = collector.getRangeCountersToBeDisplayed(this.range);
            CounterRequest myRequest = null;
            ArrayList<CounterRequest> requests = new ArrayList<CounterRequest>();
            for (Counter counter : this.counters) {
                for (CounterRequest request : counter.getOrderedRequests()) {
                    if (myRequest == null && request.getId().equals(requestId)) {
                        myRequest = request;
                    }
                    if (!request.containsChildRequest(requestId)) continue;
                    requests.add(request);
                }
            }
            this.writeRequestUsages(myRequest, requests);
        }

        private void writeRequestUsages(CounterRequest myRequest, List<CounterRequest> requests) throws IOException {
            this.writeln("<br/><b>#Utilisations_de#</b>");
            if (myRequest != null) {
                this.writer.write(HtmlCounterRequestGraphReport.htmlEncode(myRequest.getName()));
            }
            this.writeln("<br/><br/>");
            if (requests.isEmpty()) {
                this.writeln("#Aucune_requete#");
                return;
            }
            boolean someUsagesDisplayed = this.getUsagesDisplayed(requests);
            this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Utilisations_de#'>");
            this.write("<thead><tr><th>#Requete#</th>");
            if (someUsagesDisplayed) {
                this.write("<th class='noPrint'>#Chercher_utilisations#</th>");
            }
            this.writeln("</tr></thead><tbody>");
            boolean odd = false;
            for (CounterRequest request : requests) {
                if (odd) {
                    this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
                } else {
                    this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
                }
                odd = !odd;
                this.writeUsedRequest(request, someUsagesDisplayed);
                this.writeln("</tr>");
            }
            this.writeln("</tbody></table>");
        }

        private void writeUsedRequest(CounterRequest request, boolean someUsageDisplayed) throws IOException {
            this.writeln("<td>");
            this.writeCounterIcon(request);
            this.writeRequestGraph(request.getId(), request.getName());
            if (someUsageDisplayed) {
                this.writeln("</td><td align='center' class='noPrint'>");
                if (this.doesRequestDisplayUsages(request)) {
                    this.writeln("<a href='?part=usages&amp;graph=" + request.getId() + "'>");
                    this.writeln("<img src='?resource=find.png' alt='#Chercher_utilisations#' title='#Chercher_utilisations#'/></a>");
                } else {
                    this.writeln("&nbsp;");
                }
            }
            this.writeln("</td>");
        }

        private boolean getUsagesDisplayed(List<CounterRequest> requests) {
            for (CounterRequest request : requests) {
                if (!this.doesRequestDisplayUsages(request)) continue;
                return true;
            }
            return false;
        }

        private void writeRequest(CounterRequest request) throws IOException {
            boolean allChildHitsDisplayed;
            boolean hasChildren;
            Map<String, Long> childRequests = request.getChildRequestsExecutionsByRequestId();
            this.writeln("<br/><table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Drill_down#'>");
            this.writeln("<thead><tr><th>#Requete#</th>");
            boolean bl = hasChildren = !childRequests.isEmpty();
            if (hasChildren) {
                this.writeln("<th class='sorttable_numeric'>#Hits_par_requete#</th>");
            }
            this.writeln("<th class='sorttable_numeric'>#Temps_moyen#</th><th class='sorttable_numeric'>#Temps_max#</th>");
            this.writeln("<th class='sorttable_numeric'>#Ecart_type#</th><th class='sorttable_numeric'>#Temps_cpu_moyen#</th>");
            this.writeln("<th class='sorttable_numeric'>#erreur_systeme#</th>");
            Counter parentCounter = this.getCounterByRequestId(request);
            boolean bl2 = allChildHitsDisplayed = parentCounter != null && parentCounter.getChildCounterName() != null;
            if (allChildHitsDisplayed) {
                String childCounterName = parentCounter.getChildCounterName();
                this.writeln("<th class='sorttable_numeric'>" + I18N.getFormattedString("hits_fils_moyens", childCounterName));
                this.writeln("</th><th class='sorttable_numeric'>" + I18N.getFormattedString("temps_fils_moyen", childCounterName) + "</th>");
            }
            this.writeln("</tr></thead><tbody>");
            this.writeln("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\"><td>");
            this.writeCounterIcon(request);
            this.writer.write(HtmlCounterRequestGraphReport.htmlEncode(request.getName()));
            if (hasChildren) {
                this.writeln("</td><td>&nbsp;");
            }
            this.writeRequestValues(request, allChildHitsDisplayed);
            this.writeln("</td></tr>");
            if (hasChildren) {
                this.writeChildRequests(request, childRequests, allChildHitsDisplayed);
            }
            this.writeln("</tbody></table>");
            if (this.doesRequestDisplayUsages(request)) {
                this.writeln("<div align='right' class='noPrint'>");
                this.writeln("<a href='?part=usages&amp;graph=" + request.getId() + "'>");
                this.writeln("<img src='?resource=find.png' alt='#Chercher_utilisations#' ");
                this.writeln("title='#Chercher_utilisations#'/> #Chercher_utilisations#</a></div>");
            } else {
                this.writeln("<br/>");
            }
        }

        private boolean doesRequestDisplayUsages(CounterRequest request) {
            Counter parentCounter = this.getCounterByRequestId(request);
            return parentCounter != null && !parentCounter.isErrorCounter() && !"http".equals(parentCounter.getName());
        }

        private void writeChildRequests(CounterRequest request, Map<String, Long> childRequests, boolean allChildHitsDisplayed) throws IOException {
            boolean odd = true;
            for (Map.Entry<String, Long> entry : childRequests.entrySet()) {
                CounterRequest childRequest = this.requestsById.get(entry.getKey());
                if (childRequest == null) continue;
                if (odd) {
                    this.writeln("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
                } else {
                    this.writeln("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
                }
                odd = !odd;
                Long nbExecutions = entry.getValue();
                float executionsByRequest = (float)nbExecutions.longValue() / (float)request.getHits();
                this.writeChildRequest(childRequest, executionsByRequest, allChildHitsDisplayed);
                this.writeln("</tr>");
            }
        }

        private void writeChildRequest(CounterRequest childRequest, float executionsByRequest, boolean allChildHitsDisplayed) throws IOException {
            this.writeln("<td>");
            this.writeln("<div style='margin-left: 10px;'>");
            this.writeCounterIcon(childRequest);
            this.writeRequestGraph(childRequest.getId(), childRequest.getName());
            this.writeln("</div></td><td align='right'>");
            this.write(this.nbExecutionsFormat.format(executionsByRequest));
            this.writeRequestValues(childRequest, allChildHitsDisplayed);
            this.writeln("</td>");
        }

        private void writeRequestValues(CounterRequest request, boolean allChildHitsDisplayed) throws IOException {
            String nextColumn = "</td><td align='right'>";
            this.writeln("</td><td align='right'>");
            this.writeln(this.integerFormat.format(request.getMean()));
            this.writeln("</td><td align='right'>");
            this.writeln(this.integerFormat.format(request.getMaximum()));
            this.writeln("</td><td align='right'>");
            this.writeln(this.integerFormat.format(request.getStandardDeviation()));
            this.writeln("</td><td align='right'>");
            String nbsp = "&nbsp;";
            if (request.getCpuTimeMean() >= 0) {
                this.writeln(this.integerFormat.format(request.getCpuTimeMean()));
            } else {
                this.writeln("&nbsp;");
            }
            this.writeln("</td><td align='right'>");
            this.writeln(this.systemErrorFormat.format(request.getSystemErrorPercentage()));
            if (allChildHitsDisplayed) {
                this.writeln("</td><td align='right'>");
                boolean childHitsDisplayed = request.hasChildHits();
                if (childHitsDisplayed) {
                    this.writeln(this.integerFormat.format(request.getChildHitsMean()));
                } else {
                    this.writeln("&nbsp;");
                }
                this.writeln("</td><td align='right'>");
                if (childHitsDisplayed) {
                    this.writeln(this.integerFormat.format(request.getChildDurationsMean()));
                } else {
                    this.writeln("&nbsp;");
                }
            }
        }

        private void writeCounterIcon(CounterRequest request) throws IOException {
            Counter parentCounter = this.getCounterByRequestId(request);
            if (parentCounter != null && parentCounter.getIconName() != null) {
                this.writeln("<img src='?resource=" + parentCounter.getIconName() + "' alt='" + parentCounter.getName() + "' width='16' height='16' />&nbsp;");
            }
        }

        private void writeGraphDetailScript(String graphName) throws IOException {
            this.writeln(SCRIPT_BEGIN);
            this.writeln("function scaleImage(v, min, max) {");
            this.writeln("    var images = document.getElementsByClassName('synth\u00e8se');");
            this.writeln("    w = (max - min) * v + min;");
            this.writeln("    for (i = 0; i < images.length; i++) {");
            this.writeln("        images[i].style.width = w + 'px';");
            this.writeln("    }");
            this.writeln("}");
            this.writeln("var slider = new Control.Slider('handle', 'track', {axis:'horizontal', alignX: 0, increment: 2});");
            this.writeln("slider.options.onSlide = function(value) {");
            this.writeln("  scaleImage(value, initialWidth, initialWidth / 2 * 3);");
            this.writeln("}");
            this.writeln("slider.options.onChange = function(value) {");
            this.writeln("  width = Math.round(Element.getStyle('img','width').replace('px','')) - 80;");
            this.writeln("  height = Math.round(width * initialHeight / initialWidth) - 48;");
            this.writeln("  document.getElementById('img').src = '?graph=" + graphName + "\\u0026width=' + width + '\\u0026height=' + height;");
            this.writeln("  document.getElementById('img').style.width = '';");
            this.writeln("}");
            this.writeln("window.onload = function() {");
            this.writeln("  if (navigator.appName == 'Microsoft Internet Explorer') {");
            this.writeln("    initialWidth = document.getElementById('img').width;");
            this.writeln("    initialHeight = document.getElementById('img').height;");
            this.writeln("  } else {");
            this.writeln("    initialWidth = Math.round(Element.getStyle('img','width').replace('px',''));");
            this.writeln("    initialHeight = Math.round(Element.getStyle('img','height').replace('px',''));");
            this.writeln("  }");
            this.writeln("}");
            this.writeln(SCRIPT_END);
        }

        private Map<String, CounterRequest> mapAllRequestsById() {
            HashMap<String, CounterRequest> result = new HashMap<String, CounterRequest>();
            for (Counter counter : this.counters) {
                for (CounterRequest request : counter.getRequests()) {
                    result.put(request.getId(), request);
                }
            }
            return result;
        }

        private Counter getCounterByRequestId(CounterRequest request) {
            String requestId = request.getId();
            for (Counter counter : this.counters) {
                if (!requestId.startsWith(counter.getName())) continue;
                return counter;
            }
            return null;
        }

        private static String htmlEncode(String text) {
            return I18N.htmlEncode(text, false);
        }

        private void write(String html) throws IOException {
            I18N.writeTo(html, this.writer);
        }

        private void writeln(String html) throws IOException {
            I18N.writelnTo(html, this.writer);
        }
    }
}

