/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JdbcWrapperHelper;
import net.bull.javamelody.LOG;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.jndi.JndiObjectFactoryBean;

public class SpringDataSourceBeanPostProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) {
        if (bean instanceof DataSource) {
            DataSource dataSource = (DataSource)bean;
            JdbcWrapperHelper.registerSpringDataSource(beanName, dataSource);
            DataSource result = JdbcWrapper.SINGLETON.createDataSourceProxy(beanName, dataSource);
            LOG.debug("Spring datasource wrapped: " + beanName);
            return result;
        }
        if (bean instanceof JndiObjectFactoryBean) {
            InvocationHandler invocationHandler = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result = method.invoke(bean, args);
                    if (result instanceof DataSource) {
                        result = JdbcWrapper.SINGLETON.createDataSourceProxy(beanName, (DataSource)result);
                    }
                    return result;
                }
            };
            Object result = JdbcWrapper.createProxy(bean, invocationHandler);
            LOG.debug("Spring JNDI factory wrapped: " + beanName);
            return result;
        }
        return bean;
    }
}

