/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import net.bull.javamelody.I18N;

class HtmlJndiTreeReport {
    private final Context context;
    private final String path;
    private final Writer writer;

    HtmlJndiTreeReport(Context context, String path, Writer writer) {
        assert (context != null);
        assert (writer != null);
        this.context = context;
        this.path = path != null ? path : "";
        this.writer = writer;
    }

    void toHtml() throws IOException, NamingException {
        this.writeLinks();
        this.writeln("<br/>");
        this.writeln("<img src='?resource=jndi.png' width='24' height='24' alt='#Arbre_JNDI#' />&nbsp;");
        this.writeln("<b>#Arbre_JNDI#</b>");
        this.writeTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTable() throws IOException, NamingException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Arbre_JNDI#'>");
        this.write("<thead><tr><th>#Nom#</th><th>#Type#</th>");
        this.writeln("</tr></thead><tbody>");
        NamingEnumeration<Binding> enumeration = this.context.listBindings("java:" + this.path);
        try {
            boolean odd = false;
            while (enumeration.hasMore()) {
                try {
                    Binding binding = enumeration.next();
                    if (odd) {
                        this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
                    } else {
                        this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
                    }
                    odd = !odd;
                    this.writeBinding(binding);
                    this.writeln("</tr>");
                }
                catch (NamingException e) {}
            }
            this.writeln("</tbody></table>");
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            enumeration.close();
            this.context.close();
            throw throwable;
        }
        enumeration.close();
        this.context.close();
    }

    private void writeBinding(Binding binding) throws IOException {
        this.write("<td>");
        String name = binding.getName();
        String encodedName = HtmlJndiTreeReport.htmlEncode(name);
        if (binding.getObject() instanceof Context) {
            this.writer.write("<a href=\"?part=jndi&amp;path=" + HtmlJndiTreeReport.htmlEncode(this.path + '/' + name) + "\">");
            this.writer.write("<img width='16' height='16' src='?resource=folder.png' alt='" + encodedName + "' />&nbsp;");
            this.writer.write(encodedName);
            this.writer.write("</a>");
        } else {
            this.writer.write(encodedName);
        }
        this.write("</td>");
        this.write("<td>");
        String className = binding.getClassName();
        this.writer.write(className != null ? HtmlJndiTreeReport.htmlEncode(className) : "&nbsp;");
        this.write("</td>");
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=jndi&amp;path=" + HtmlJndiTreeReport.htmlEncode(this.path) + "'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, true);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

