/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

final class JspWrapper
implements InvocationHandler {
    private static final Counter JSP_COUNTER = new Counter("jsp", "jsp.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(JSP_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));
    private final String path;
    private final RequestDispatcher requestDispatcher;

    JspWrapper(String path, RequestDispatcher requestDispatcher) {
        assert (path != null);
        assert (requestDispatcher != null);
        JSP_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        this.path = path;
        this.requestDispatcher = requestDispatcher;
    }

    static HttpServletRequest createHttpRequestWrapper(HttpServletRequest request) {
        if (DISABLED || COUNTER_HIDDEN) {
            return request;
        }
        return new HttpRequestWrapper(request);
    }

    static Counter getJspCounter() {
        return JSP_COUNTER;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!"include".equals(methodName) && !"forward".equals(methodName)) {
            return method.invoke((Object)this.requestDispatcher, args);
        }
        boolean systemError = false;
        try {
            String pathWithoutParameters = this.path.indexOf(63) != -1 ? this.path.substring(0, this.path.indexOf(63)) : this.path;
            JSP_COUNTER.bindContextIncludingCpu(pathWithoutParameters);
            Object object = method.invoke((Object)this.requestDispatcher, args);
            Object var9_9 = null;
            JSP_COUNTER.addRequestForCurrentContext(systemError);
            return object;
        }
        catch (InvocationTargetException e) {
            try {
                if (e.getCause() instanceof Error) {
                    systemError = true;
                }
                throw e;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                JSP_COUNTER.addRequestForCurrentContext(systemError);
                throw throwable;
            }
        }
    }

    private static class HttpRequestWrapper
    extends HttpServletRequestWrapper {
        HttpRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            RequestDispatcher requestDispatcher = super.getRequestDispatcher(path);
            if (requestDispatcher == null) {
                return null;
            }
            JspWrapper invocationHandler = new JspWrapper(String.valueOf(path), requestDispatcher);
            return JdbcWrapper.createProxy(requestDispatcher, invocationHandler);
        }
    }
}

