/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import org.hibernate.Interceptor;
import org.hibernate.ScrollMode;
import org.hibernate.cfg.Settings;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.jdbc.BatchingBatcher;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.jdbc.NonBatchingBatcher;

public class HibernateBatcherFactory
implements BatcherFactory {
    static PreparedStatement createPreparedStatementProxy(String query, PreparedStatement statement) {
        return (PreparedStatement)JdbcWrapper.SINGLETON.createStatementProxy(query, statement);
    }

    static CallableStatement createCallableStatementProxy(String query, CallableStatement statement) {
        return (CallableStatement)JdbcWrapper.SINGLETON.createStatementProxy(query, statement);
    }

    public Batcher createBatcher(ConnectionManager connectionManager, Interceptor interceptor) {
        boolean sqlMonitoringDisabled = JdbcWrapper.SINGLETON.isSqlMonitoringDisabled();
        Settings settings = connectionManager.getFactory().getSettings();
        if (sqlMonitoringDisabled) {
            if (settings.getJdbcBatchSize() == 0) {
                return new NonBatchingBatcher(connectionManager, interceptor);
            }
            return new BatchingBatcher(connectionManager, interceptor);
        }
        Object result = settings.getJdbcBatchSize() == 0 ? new HibernateBatchingBatcher(connectionManager, interceptor) : new HibernateNonBatchingBatcher(connectionManager, interceptor);
        LOG.debug("hibernate batcher factory initialized");
        return result;
    }

    private static class HibernateNonBatchingBatcher
    extends NonBatchingBatcher {
        HibernateNonBatchingBatcher(ConnectionManager connectionManager, Interceptor interceptor) {
            super(connectionManager, interceptor);
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareStatement(sql));
        }

        public PreparedStatement prepareBatchStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareBatchStatement(sql));
        }

        public PreparedStatement prepareSelectStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareSelectStatement(sql));
        }

        public PreparedStatement prepareStatement(String sql, boolean getGeneratedKeys) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareStatement(sql, getGeneratedKeys));
        }

        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareStatement(sql, columnNames));
        }

        public PreparedStatement prepareQueryStatement(String sql, boolean scrollable, ScrollMode scrollMode) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareQueryStatement(sql, scrollable, scrollMode));
        }

        public CallableStatement prepareBatchCallableStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createCallableStatementProxy(sql, super.prepareBatchCallableStatement(sql));
        }

        public CallableStatement prepareCallableStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createCallableStatementProxy(sql, super.prepareCallableStatement(sql));
        }

        public CallableStatement prepareCallableQueryStatement(String sql, boolean scrollable, ScrollMode scrollMode) throws SQLException {
            return HibernateBatcherFactory.createCallableStatementProxy(sql, super.prepareCallableQueryStatement(sql, scrollable, scrollMode));
        }
    }

    private static class HibernateBatchingBatcher
    extends BatchingBatcher {
        HibernateBatchingBatcher(ConnectionManager connectionManager, Interceptor interceptor) {
            super(connectionManager, interceptor);
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareStatement(sql));
        }

        public PreparedStatement prepareBatchStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareBatchStatement(sql));
        }

        public PreparedStatement prepareStatement(String sql, boolean getGeneratedKeys) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareStatement(sql, getGeneratedKeys));
        }

        public PreparedStatement prepareSelectStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareSelectStatement(sql));
        }

        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareStatement(sql, columnNames));
        }

        public PreparedStatement prepareQueryStatement(String sql, boolean scrollable, ScrollMode scrollMode) throws SQLException {
            return HibernateBatcherFactory.createPreparedStatementProxy(sql, super.prepareQueryStatement(sql, scrollable, scrollMode));
        }

        public CallableStatement prepareCallableStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createCallableStatementProxy(sql, super.prepareCallableStatement(sql));
        }

        public CallableStatement prepareCallableQueryStatement(String sql, boolean scrollable, ScrollMode scrollMode) throws SQLException {
            return HibernateBatcherFactory.createCallableStatementProxy(sql, super.prepareCallableQueryStatement(sql, scrollable, scrollMode));
        }

        public CallableStatement prepareBatchCallableStatement(String sql) throws SQLException {
            return HibernateBatcherFactory.createCallableStatementProxy(sql, super.prepareBatchCallableStatement(sql));
        }
    }
}

