/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import net.bull.javamelody.I18N;

class MemoryInformations
implements Serializable {
    private static final long serialVersionUID = 3281861236369720876L;
    private static final String NEXT = ",\n";
    private static final String MO = " Mo";
    private final long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    private final long maxMemory = Runtime.getRuntime().maxMemory();
    private final long usedPermGen;
    private final long maxPermGen;
    private final long usedNonHeapMemory;
    private final int loadedClassesCount;
    private final long garbageCollectionTimeMillis;
    private final long usedPhysicalMemorySize;
    private final long usedSwapSpaceSize;
    private final String memoryDetails;

    MemoryInformations() {
        MemoryPoolMXBean permGenMemoryPool = MemoryInformations.getPermGenMemoryPool();
        if (permGenMemoryPool != null) {
            MemoryUsage usage = permGenMemoryPool.getUsage();
            this.usedPermGen = usage.getUsed();
            this.maxPermGen = usage.getMax();
        } else {
            this.usedPermGen = -1L;
            this.maxPermGen = -1L;
        }
        this.usedNonHeapMemory = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
        this.loadedClassesCount = ManagementFactory.getClassLoadingMXBean().getLoadedClassCount();
        this.garbageCollectionTimeMillis = MemoryInformations.buildGarbageCollectionTimeMillis();
        java.lang.management.OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        if (MemoryInformations.isSunOsMBean(operatingSystem)) {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)operatingSystem;
            this.usedPhysicalMemorySize = osBean.getTotalPhysicalMemorySize() - osBean.getFreePhysicalMemorySize();
            this.usedSwapSpaceSize = osBean.getTotalSwapSpaceSize() - osBean.getFreeSwapSpaceSize();
        } else {
            this.usedPhysicalMemorySize = -1L;
            this.usedSwapSpaceSize = -1L;
        }
        this.memoryDetails = this.buildMemoryDetails();
    }

    private static MemoryPoolMXBean getPermGenMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!"Perm Gen".equals(memoryPool.getName())) continue;
            return memoryPool;
        }
        return null;
    }

    private static long buildGarbageCollectionTimeMillis() {
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean garbageCollector : ManagementFactory.getGarbageCollectorMXBeans()) {
            garbageCollectionTime += garbageCollector.getCollectionTime();
        }
        return garbageCollectionTime;
    }

    private String buildMemoryDetails() {
        DecimalFormat integerFormat = I18N.createIntegerFormat();
        String nonHeapMemory = "Non heap memory = " + integerFormat.format(this.usedNonHeapMemory / 1024L / 1024L) + MO + " (Perm Gen, Code Cache)";
        String classLoading = "Loaded classes = " + integerFormat.format(this.loadedClassesCount);
        String gc = "Garbage collection time = " + integerFormat.format(this.garbageCollectionTimeMillis) + " ms";
        java.lang.management.OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        String osInfo = "";
        if (MemoryInformations.isSunOsMBean(operatingSystem)) {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)operatingSystem;
            osInfo = "Process cpu time = " + integerFormat.format(osBean.getProcessCpuTime() / 1000000L) + " ms,\nCommitted virtual memory = " + integerFormat.format(osBean.getCommittedVirtualMemorySize() / 1024L / 1024L) + MO + ",\nFree physical memory = " + integerFormat.format(osBean.getFreePhysicalMemorySize() / 1024L / 1024L) + MO + ",\nTotal physical memory = " + integerFormat.format(osBean.getTotalPhysicalMemorySize() / 1024L / 1024L) + MO + ",\nFree swap space = " + integerFormat.format(osBean.getFreeSwapSpaceSize() / 1024L / 1024L) + MO + ",\nTotal swap space = " + integerFormat.format(osBean.getTotalSwapSpaceSize() / 1024L / 1024L) + MO;
        }
        return nonHeapMemory + NEXT + classLoading + NEXT + gc + NEXT + osInfo;
    }

    private static boolean isSunOsMBean(java.lang.management.OperatingSystemMXBean operatingSystem) {
        String className = operatingSystem.getClass().getName();
        return "com.sun.management.OperatingSystem".equals(className) || "com.sun.management.UnixOperatingSystem".equals(className);
    }

    long getUsedMemory() {
        return this.usedMemory;
    }

    long getMaxMemory() {
        return this.maxMemory;
    }

    double getUsedMemoryPercentage() {
        return 100.0 * (double)this.usedMemory / (double)this.maxMemory;
    }

    long getUsedPermGen() {
        return this.usedPermGen;
    }

    long getMaxPermGen() {
        return this.maxPermGen;
    }

    double getUsedPermGenPercentage() {
        if (this.usedPermGen > 0L && this.maxPermGen > 0L) {
            return 100.0 * (double)this.usedPermGen / (double)this.maxPermGen;
        }
        return -1.0;
    }

    long getUsedNonHeapMemory() {
        return this.usedNonHeapMemory;
    }

    int getLoadedClassesCount() {
        return this.loadedClassesCount;
    }

    long getGarbageCollectionTimeMillis() {
        return this.garbageCollectionTimeMillis;
    }

    long getUsedPhysicalMemorySize() {
        return this.usedPhysicalMemorySize;
    }

    long getUsedSwapSpaceSize() {
        return this.usedSwapSpaceSize;
    }

    String getMemoryDetails() {
        return this.memoryDetails;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[usedMemory=" + this.getUsedMemory() + ", maxMemroy=" + this.getMaxMemory() + ']';
    }
}

