/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JobInformations;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

final class JobGlobalListener
implements JobListener {
    private static final Counter JOB_COUNTER = new Counter("job", "jobs.png", JdbcWrapper.SINGLETON.getSqlCounter());

    JobGlobalListener() {
    }

    static Counter getJobCounter() {
        return JOB_COUNTER;
    }

    static void initJobGlobalListener() {
        try {
            JobGlobalListener jobGlobalListener = new JobGlobalListener();
            Scheduler defaultScheduler = StdSchedulerFactory.getDefaultScheduler();
            defaultScheduler.addGlobalJobListener((JobListener)jobGlobalListener);
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                if (scheduler == defaultScheduler) continue;
                scheduler.addGlobalJobListener((JobListener)jobGlobalListener);
            }
        }
        catch (SchedulerException e) {
            throw new IllegalStateException(e);
        }
    }

    static void destroyJobGlobalListener() {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                List globalJobListeners = scheduler.getGlobalJobListeners();
                for (JobListener jobListener : new ArrayList(globalJobListeners)) {
                    if (!(jobListener instanceof JobGlobalListener)) continue;
                    scheduler.removeGlobalJobListener(jobListener);
                }
            }
        }
        catch (SchedulerException e) {
            throw new IllegalStateException(e);
        }
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobDetail jobDetail = context.getJobDetail();
        String jobFullName = jobDetail.getGroup() + '.' + jobDetail.getName();
        JOB_COUNTER.bindContextIncludingCpu(jobFullName);
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        JOB_COUNTER.unbindContext();
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        String stackTrace;
        if (jobException == null) {
            stackTrace = null;
        } else {
            StringWriter stackTraceWriter = new StringWriter(200);
            jobException.printStackTrace(new PrintWriter(stackTraceWriter));
            stackTrace = stackTraceWriter.toString();
        }
        JOB_COUNTER.addRequestForCurrentContext(stackTrace);
    }

    public String getName() {
        return this.getClass().getName();
    }
}

