/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlJobInformationsReport {
    private final List<JobInformations> jobInformationsList;
    private final Period period;
    private final Writer writer;
    private final DateFormat fireTimeFormat = I18N.createDateAndTimeFormat();
    private final DateFormat elapsedTimeFormat = I18N.createDurationFormat();
    private final boolean systemActionsEnabled = Boolean.parseBoolean(Parameters.getParameter(Parameter.SYSTEM_ACTIONS_ENABLED));

    HtmlJobInformationsReport(List<JobInformations> jobInformationsList, Period period, Writer writer) {
        assert (jobInformationsList != null);
        assert (period != null);
        assert (writer != null);
        this.jobInformationsList = jobInformationsList;
        this.period = period;
        this.writer = writer;
    }

    void toHtml() throws IOException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Jobs#'>");
        this.write("<thead><tr><th>#JobGroup#</th>");
        this.write("<th>#JobName#</th>");
        this.write("<th>#JobDescription#</th>");
        this.write("<th>#JobClassName#</th>");
        this.write("<th class='sorttable_date'>#JobPreviousFireTime#</th>");
        this.write("<th class='sorttable_date'>#JobNextFireTime#</th>");
        this.write("<th class='sorttable_date'>#JobElapsedTime#</th>");
        this.write("<th>#JobPaused#</th>");
        if (this.systemActionsEnabled) {
            this.write("<th class='noPrint'>#Pause_job#</th>");
            this.write("<th class='noPrint'>#Resume_job#</th>");
        }
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (JobInformations jobInformations : this.jobInformationsList) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeJobInformations(jobInformations);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
        this.write("<div align='right' class='noPrint'>");
        if (this.systemActionsEnabled) {
            this.writeln("<a href='?action=pause_job&amp;jobId=all&amp;period=" + this.period.getCode() + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_pause_all_jobs") + "');\">");
            this.writeln("<img src='?resource=control_pause_blue.png' width='18' height='18' alt=\"#Pause_all_jobs#\" /> #Pause_all_jobs#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?action=resume_job&amp;jobId=all&amp;period=" + this.period.getCode() + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_resume_all_jobs") + "');\">");
            this.writeln("<img src='?resource=control_play_blue.png' width='18' height='18' alt=\"#Resume_all_jobs#\" /> #Resume_all_jobs#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writer.write("<a href='http://www.quartz-scheduler.org/docs/index.html'");
        this.writeln("target='_blank'>Configuration reference</a></div>");
    }

    private void writeJobInformations(JobInformations jobInformations) throws IOException {
        this.write("<td>");
        String nextColumn = "</td> <td>";
        String nextColumnAlignRight = "</td> <td align='right'>";
        this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getGroup()));
        this.write("</td> <td>");
        this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getName()));
        this.write("</td> <td>");
        if (jobInformations.getDescription() != null) {
            this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getDescription()));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td>");
        this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getJobClassName()));
        this.write("</td> <td align='right'>");
        if (jobInformations.getPreviousFireTime() != null) {
            this.write(this.fireTimeFormat.format(jobInformations.getPreviousFireTime()));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='right'>");
        if (jobInformations.getNextFireTime() != null) {
            this.write(this.fireTimeFormat.format(jobInformations.getNextFireTime()));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='right'>");
        if (jobInformations.getElapsedTime() >= 0L) {
            this.write(this.elapsedTimeFormat.format(new Date(jobInformations.getElapsedTime())));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='center'>");
        if (jobInformations.isPaused()) {
            this.write("#oui#");
        } else {
            this.write("#non#");
        }
        if (this.systemActionsEnabled) {
            this.write("</td> <td align='center' class='noPrint'>");
            this.writeln("<a href='?action=pause_job&amp;jobId=" + jobInformations.getGlobalJobId() + "&amp;period=" + this.period.getCode() + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_pause_job") + "');\">");
            this.writeln("<img src='?resource=control_pause_blue.png' width='18' height='18' alt=\"#Pause_job#\" title=\"#Pause_job#\" /></a>");
            this.write("</td> <td align='center' class='noPrint'>");
            this.writeln("<a href='?action=resume_job&amp;jobId=" + jobInformations.getGlobalJobId() + "&amp;period=" + this.period.getCode() + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_resume_job") + "');\">");
            this.writeln("<img src='?resource=control_play_blue.png' width='18' height='18' alt=\"#Resume_job#\" title=\"#Resume_job#\" /></a>");
        }
        this.write("</td>");
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, false);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

