/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.Action;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlHeapHistogramReport {
    private final Writer writer;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();

    HtmlHeapHistogramReport(Writer writer) {
        assert (writer != null);
        this.writer = writer;
    }

    void toHtml(HeapHistogram heapHistogram) throws IOException {
        assert (heapHistogram != null);
        this.writeLinks();
        this.writeln("<br/>");
        this.writeln("<img src='?resource=memory.png' width='24' height='24' alt='#memoire#' />&nbsp;");
        this.writeln("<b>" + I18N.getFormattedString("heap_histo_du", I18N.createDateAndTimeFormat().format(heapHistogram.getTime())) + "</b>");
        this.writeln("<br/><br/><b>#Heap#</b>");
        String separator = "&nbsp;&nbsp;&nbsp;";
        this.writeln("&nbsp;&nbsp;&nbsp;");
        List<HeapHistogram.ClassInfo> heap = heapHistogram.getHeapHistogram();
        long totalHeapInstances = heapHistogram.getTotalHeapInstances();
        long totalHeapBytes = heapHistogram.getTotalHeapBytes();
        this.writeln("#Classes#: " + this.integerFormat.format(heap.size()) + ',');
        this.writeln("&nbsp;&nbsp;&nbsp;");
        this.writeln("#Instances#: " + this.integerFormat.format(totalHeapInstances) + ',');
        this.writeln("&nbsp;&nbsp;&nbsp;");
        this.writeln("#Kilo-Octets#: " + this.integerFormat.format(totalHeapBytes / 1024L));
        this.writeClassInfo(heap, totalHeapInstances, totalHeapBytes, true, heapHistogram.isSourceDisplayed(), heapHistogram.isDeltaDisplayed());
        List<HeapHistogram.ClassInfo> permGen = heapHistogram.getPermGenHistogram();
        if (!permGen.isEmpty()) {
            this.writeln("<br/><br/><b>#PermGen#</b>");
            this.writeln("&nbsp;&nbsp;&nbsp;");
            long totalPermGenInstances = heapHistogram.getTotalPermGenInstances();
            long totalPermGenBytes = heapHistogram.getTotalPermGenBytes();
            this.writeln("#Classes#: " + this.integerFormat.format(permGen.size()) + ',');
            this.writeln("&nbsp;&nbsp;&nbsp;");
            this.writeln("#Instances#: " + this.integerFormat.format(totalPermGenInstances) + ',');
            this.writeln("&nbsp;&nbsp;&nbsp;");
            this.writeln("#Kilo-Octets#: " + this.integerFormat.format(totalPermGenBytes / 1024L));
            this.writeClassInfo(permGen, totalPermGenInstances, totalPermGenBytes, false, false, false);
        }
    }

    private void writeClassInfo(List<HeapHistogram.ClassInfo> classHistogram, long totalInstances, long totalBytes, boolean heap, boolean sourceDisplayed, boolean deltaDisplayed) throws IOException {
        String tableTag = "<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#histogramme#'>";
        String theadTag = "<thead><tr><th>#Classe#</th><th>#Taille#</th><th>#pct_taille#</th>" + (deltaDisplayed ? "<th>#Delta#</th>" : "") + "<th>#Instances#</th><th>#pct_instances#</th>" + (sourceDisplayed ? "<th>#Source#</th>" : "") + "</tr></thead><tbody>";
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#histogramme#'>");
        this.write(theadTag);
        boolean odd = false;
        for (HeapHistogram.ClassInfo classInfo : classHistogram) {
            if (classInfo.getBytes() * 100L / totalBytes == 0L) break;
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeClassInfo(classInfo, totalInstances, totalBytes, heap, sourceDisplayed, deltaDisplayed);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
        this.writeln("<div align='right'>");
        String id = heap ? "detailsHeap" : "detailsPermGen";
        this.writeShowHideLink(id, "#Details#");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("</div><div id='" + id + "' style='display:none;'>");
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#histogramme#'>");
        this.write(theadTag);
        odd = false;
        for (HeapHistogram.ClassInfo classInfo : classHistogram) {
            if (classInfo.getBytes() * 100L / totalBytes != 0L) continue;
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeClassInfo(classInfo, totalInstances, totalBytes, heap, sourceDisplayed, deltaDisplayed);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table></div>");
    }

    private void writeClassInfo(HeapHistogram.ClassInfo classInfo, long totalInstances, long totalBytes, boolean heap, boolean sourceDisplayed, boolean deltaDisplayed) throws IOException {
        this.write("<td>");
        if (heap) {
            this.write(classInfo.getName());
        } else {
            this.write(classInfo.getName().replaceAll("[<]", "&lt;").replaceAll("[>]", "&gt;"));
        }
        String nextColumnAlignRight = "</td><td align='right'>";
        this.write("</td><td align='right'>");
        long bytes = classInfo.getBytes();
        long instancesCount = classInfo.getInstancesCount();
        this.write(this.integerFormat.format(bytes / 1024L));
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(bytes * 100L / totalBytes));
        if (deltaDisplayed) {
            this.write("</td><td align='right'>");
            if (classInfo.getBytesDelta() > 0L) {
                this.write("+");
            }
            this.write(this.integerFormat.format(classInfo.getBytesDelta() / 1024L));
        }
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(instancesCount));
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(instancesCount * 100L / totalInstances));
        this.write("</td>");
        if (sourceDisplayed) {
            this.write("<td>");
            String source = classInfo.getSource();
            if (source == null) {
                this.write("&nbsp;");
            } else {
                this.write(source);
            }
            this.write("</td>");
        }
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=heaphisto'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        if (Action.GC_ENABLED) {
            this.writeln("<a href='?part=heaphisto&amp;action=gc' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_ramasse_miette") + "');\">");
            this.writeln("<img src='?resource=broom.png' width='16' height='16' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        } else {
            this.writeln("<a href='#' onclick=\"javascript:alert('" + I18N.getStringForJavascript("ramasse_miette_desactive") + "');return false;\">");
            this.writeln("<img src='?resource=broom.png' width='16' height='16' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        if (Action.HEAP_DUMP_ENABLED) {
            this.writeln("<a href='?part=heaphisto&amp;action=heap_dump' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_heap_dump") + "');\">");
            this.writeln("<img src='?resource=heapdump.png' width='16' height='16' alt='#heap_dump#' /> #heap_dump#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writeln("</div>");
    }

    private void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writeln("<a href=\"javascript:showHide('" + idToShow + "');\" class='noPrint'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

