/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.util.Locale;
import net.bull.javamelody.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Period {
    JOUR(86400, "calendar_view_day.png", "day"),
    SEMAINE(604800, "calendar_view_week.png", "week"),
    MOIS(2678400, "calendar_view_month.png", "month"),
    ANNEE(31622400, "calendar.png", "year"),
    TOUT(63244800, "calendar.png", "all");

    private final String code;
    private final String mailCode;
    private final int durationSeconds;
    private final String iconName;

    private Period(int durationSeconds, String iconName, String mailCode) {
        this.durationSeconds = durationSeconds;
        this.iconName = iconName;
        this.mailCode = mailCode;
        this.code = this.toString().toLowerCase(Locale.getDefault());
    }

    static Period valueOfIgnoreCase(String period) {
        return Period.valueOf(period.toUpperCase(Locale.getDefault()).trim());
    }

    static Period valueOfByMailCode(String mailPeriod) {
        String mailCode = mailPeriod.toLowerCase(Locale.getDefault()).trim();
        for (Period period : Period.values()) {
            if (!period.mailCode.equals(mailCode)) continue;
            return period;
        }
        throw new IllegalArgumentException(mailPeriod);
    }

    String getCode() {
        return this.code;
    }

    String getMailCode() {
        return this.mailCode;
    }

    String getLabel() {
        return I18N.getString(this.code + "_label");
    }

    String getLinkLabel() {
        return I18N.getString(this.code + "_link_label");
    }

    int getDurationSeconds() {
        return this.durationSeconds;
    }

    String getIconName() {
        return this.iconName;
    }
}

