/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfCacheInformationsReport;
import net.bull.javamelody.PdfCounterReport;
import net.bull.javamelody.PdfCounterRequestContextReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfJavaInformationsReport;
import net.bull.javamelody.PdfThreadInformationsReport;
import net.bull.javamelody.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfReport {
    private final Collector collector;
    private final List<JavaInformations> javaInformationsList;
    private final Period period;
    private final Document document;
    private final boolean collectorServer;
    private final PdfDocumentFactory pdfDocumentFactory;
    private final Font normalFont = PdfDocumentFactory.NORMAL_FONT;
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private final long start = System.currentTimeMillis();

    PdfReport(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Period period, OutputStream output) throws IOException {
        assert (collector != null);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (period != null);
        assert (output != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.javaInformationsList = javaInformationsList;
        this.period = period;
        try {
            this.pdfDocumentFactory = new PdfDocumentFactory(collector.getApplication(), output);
            this.document = this.pdfDocumentFactory.createDocument();
        }
        catch (DocumentException e) {
            throw PdfReport.createIOException(e);
        }
    }

    static String getFileName(String application) {
        return "JavaMelody_" + application.replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + ".pdf";
    }

    void toPdf() throws IOException {
        try {
            this.document.open();
            this.writeContent();
        }
        catch (DocumentException e) {
            throw PdfReport.createIOException(e);
        }
        this.document.close();
    }

    private static IOException createIOException(DocumentException e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    private void writeContent() throws IOException, DocumentException {
        this.addParagraph(this.buildSummary(), "systemmonitor.png");
        this.writeGraphs();
        ArrayList<PdfCounterReport> pdfCounterReports = new ArrayList<PdfCounterReport>();
        for (Counter counter : this.collector.getPeriodCountersToBeDisplayed(this.period)) {
            String counterLabel = I18N.getString(counter.getName() + "Label");
            this.addParagraph(I18N.getFormattedString("Statistiques_compteur", counterLabel) + " - " + this.period.getLabel(), counter.getIconName());
            PdfCounterReport pdfCounterReport = new PdfCounterReport(this.collector, counter, this.period, false, this.document);
            pdfCounterReport.toPdf();
            pdfCounterReports.add(pdfCounterReport);
        }
        ArrayList<PdfCounterRequestContextReport> pdfCounterRequestContextReports = new ArrayList<PdfCounterRequestContextReport>();
        if (!this.collectorServer) {
            this.addParagraph(PdfReport.getI18nString("Requetes_en_cours"), "hourglass.png");
            JavaInformations javaInformations = this.javaInformationsList.get(0);
            pdfCounterRequestContextReports.addAll(this.writeCurrentRequests(javaInformations, pdfCounterReports));
        }
        this.add((Element)new Phrase("\n", this.normalFont));
        this.addParagraph(PdfReport.getI18nString("Informations_systemes"), "systeminfo.png");
        new PdfJavaInformationsReport(this.javaInformationsList, this.document).toPdf();
        this.addParagraph(PdfReport.getI18nString("Threads"), "threads.png");
        this.writeThreads(false);
        if (this.isCacheEnabled()) {
            this.add((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfReport.getI18nString("Caches"), "caches.png");
            this.writeCaches(false);
        }
        this.document.newPage();
        this.addParagraph(PdfReport.getI18nString("Statistiques_detaillees"), "systemmonitor.png");
        this.writeGraphDetails();
        for (PdfCounterReport pdfCounterReport : pdfCounterReports) {
            String counterLabel = I18N.getString(pdfCounterReport.getCounterName() + "Label");
            this.addParagraph(I18N.getFormattedString("Statistiques_compteur_detaillees", counterLabel) + " - " + this.period.getLabel(), pdfCounterReport.getCounterIconName());
            pdfCounterReport.writeRequestDetails();
            if (!pdfCounterReport.isErrorCounter()) continue;
            this.addParagraph(I18N.getString(pdfCounterReport.getCounterName() + "ErrorLabel") + " - " + this.period.getLabel(), pdfCounterReport.getCounterIconName());
            pdfCounterReport.writeErrorDetails();
        }
        if (!this.collectorServer) {
            this.addParagraph(PdfReport.getI18nString("Requetes_en_cours_detaillees"), "hourglass.png");
            this.writeCurrentRequestsDetails(pdfCounterRequestContextReports);
        }
        this.addParagraph(PdfReport.getI18nString("Informations_systemes_detaillees"), "systeminfo.png");
        new PdfJavaInformationsReport(this.javaInformationsList, this.document).writeInformationsDetails();
        this.addParagraph(PdfReport.getI18nString("Threads_detailles"), "threads.png");
        this.writeThreads(true);
        if (this.isCacheEnabled()) {
            this.add((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfReport.getI18nString("Caches_detailles"), "caches.png");
            this.writeCaches(true);
        }
        this.writePoweredBy();
        this.writeDurationAndOverhead();
    }

    private String buildSummary() {
        String startDate = I18N.createDateAndTimeFormat().format(this.collector.getCounters().get(0).getStartDate());
        String tmp = I18N.getFormattedString("Statistiques", "JavaMelody", I18N.getCurrentDateAndTime(), startDate, this.collector.getApplication());
        if (this.javaInformationsList.get(0).getContextDisplayName() != null) {
            return tmp + " (" + this.javaInformationsList.get(0).getContextDisplayName() + ')';
        }
        return tmp;
    }

    private void writeGraphs() throws IOException, DocumentException {
        Paragraph jrobinParagraph = new Paragraph("", PdfDocumentFactory.getFont(9.0f, 0));
        jrobinParagraph.setAlignment(1);
        jrobinParagraph.add((Object)new Phrase("\n\n\n\n"));
        for (JRobin jrobin : this.collector.getCounterJRobins()) {
            String jrobinName = jrobin.getName();
            if (this.isJRobinDisplayed(jrobinName)) {
                if (jrobinName.endsWith("HitsRate")) {
                    jrobinParagraph.add((Object)new Phrase("\n\n\n\n\n"));
                }
                Image image = Image.getInstance((byte[])jrobin.graph(this.period, 200, 50));
                image.scalePercent(50.0f);
                jrobinParagraph.add((Object)new Phrase(new Chunk(image, 0.0f, 0.0f)));
                jrobinParagraph.add((Object)new Phrase(" "));
            }
            if (!"httpSessions".equals(jrobinName) && !"fileDescriptors".equals(jrobinName)) continue;
            jrobinParagraph.add((Object)new Phrase("\n\n\n\n\n"));
        }
        jrobinParagraph.add((Object)new Phrase("\n"));
        this.add((Element)jrobinParagraph);
    }

    private void writeGraphDetails() throws IOException, DocumentException {
        PdfPTable jrobinTable = new PdfPTable(1);
        jrobinTable.setHorizontalAlignment(1);
        jrobinTable.setWidthPercentage(100.0f);
        jrobinTable.getDefaultCell().setBorder(0);
        for (JRobin jrobin : this.collector.getCounterJRobins()) {
            String jrobinName = jrobin.getName();
            if (!this.isJRobinDisplayed(jrobinName)) continue;
            Image image = Image.getInstance((byte[])jrobin.graph(this.period, 960, 370));
            jrobinTable.addCell(image);
        }
        this.document.add((Element)jrobinTable);
        this.document.newPage();
    }

    private boolean isJRobinDisplayed(String jrobinName) {
        for (Counter counter : this.collector.getCounters()) {
            if (!jrobinName.startsWith(counter.getName())) continue;
            return counter.isDisplayed();
        }
        return true;
    }

    private List<PdfCounterRequestContextReport> writeCurrentRequests(JavaInformations javaInformations, List<PdfCounterReport> pdfCounterReports) throws IOException, DocumentException {
        ArrayList<PdfCounterRequestContextReport> pdfCounterRequestContextReports = new ArrayList<PdfCounterRequestContextReport>();
        List<CounterRequestContext> rootCurrentContexts = this.collector.getRootCurrentContexts();
        if (rootCurrentContexts.isEmpty()) {
            this.add((Element)new Phrase(PdfReport.getI18nString("Aucune_requete_en_cours"), this.normalFont));
        } else {
            PdfCounterRequestContextReport pdfCounterRequestContextReport = new PdfCounterRequestContextReport(rootCurrentContexts, pdfCounterReports, javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.pdfDocumentFactory, this.document);
            pdfCounterRequestContextReport.toPdf();
            pdfCounterRequestContextReports.add(pdfCounterRequestContextReport);
        }
        return pdfCounterRequestContextReports;
    }

    private void writeCurrentRequestsDetails(List<PdfCounterRequestContextReport> pdfCounterRequestContextReports) throws IOException, DocumentException {
        for (PdfCounterRequestContextReport pdfCounterRequestContextReport : pdfCounterRequestContextReports) {
            pdfCounterRequestContextReport.writeContextDetails();
        }
        if (pdfCounterRequestContextReports.isEmpty()) {
            this.add((Element)new Phrase(PdfReport.getI18nString("Aucune_requete_en_cours"), this.normalFont));
        }
    }

    private void writeThreads(boolean includeDetails) throws DocumentException, IOException {
        String eol = "";
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.add((Element)new Phrase(eol + PdfReport.getI18nString("Threads_sur") + ' ' + javaInformations.getHost() + ": ", PdfDocumentFactory.BOLD_FONT));
            this.add((Element)new Phrase(I18N.getFormattedString("thread_count", javaInformations.getThreadCount(), javaInformations.getPeakThreadCount(), javaInformations.getTotalStartedThreadCount()), this.normalFont));
            PdfThreadInformationsReport pdfThreadInformationsReport = new PdfThreadInformationsReport(javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.pdfDocumentFactory, this.document);
            pdfThreadInformationsReport.writeDeadlocks();
            if (includeDetails) {
                pdfThreadInformationsReport.toPdf();
            }
            eol = "\n";
        }
    }

    private void writeCaches(boolean includeDetails) throws DocumentException {
        String eol = "";
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            List<CacheInformations> cacheInformationsList = javaInformations.getCacheInformationsList();
            this.add((Element)new Phrase(eol + cacheInformationsList.size() + ' ' + PdfReport.getI18nString("caches_sur") + ' ' + javaInformations.getHost(), PdfDocumentFactory.BOLD_FONT));
            if (includeDetails) {
                new PdfCacheInformationsReport(cacheInformationsList, this.document).toPdf();
            }
            eol = "\n";
        }
    }

    private boolean isCacheEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            return true;
        }
        return false;
    }

    private void writePoweredBy() throws DocumentException, IOException {
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment("Center");
        paragraph.add((Object)new Phrase("\nPowered by   ", this.normalFont));
        Image imageBull = PdfDocumentFactory.getImage("logobull.png");
        imageBull.setAnnotation(this.pdfDocumentFactory.createAnnotation("http://www.bull.com/fr/"));
    }

    private void writeDurationAndOverhead() throws DocumentException {
        long displayDuration = System.currentTimeMillis() - this.start;
        String string = '\n' + PdfReport.getI18nString("temps_derniere_collecte") + ": " + this.collector.getLastCollectDuration() + ' ' + PdfReport.getI18nString("ms") + '\n' + PdfReport.getI18nString("temps_affichage") + ": " + displayDuration + ' ' + PdfReport.getI18nString("ms") + '\n' + PdfReport.getI18nString("Estimation_overhead_memoire") + ": < " + (this.collector.getEstimatedMemorySize() / 1024L / 1024L + 1L) + ' ' + PdfReport.getI18nString("Mo");
        if (Parameters.JAVAMELODY_VERSION != null) {
            string = string + "\n\nJavaMelody " + Parameters.JAVAMELODY_VERSION;
        }
        this.add((Element)new Phrase(string, this.cellFont));
    }

    private void addParagraph(String paragraphTitle, String iconName) throws DocumentException, IOException {
        Paragraph paragraph = new Paragraph("", PdfDocumentFactory.PARAGRAPH_TITLE_FONT);
        paragraph.setSpacingBefore(5.0f);
        paragraph.setSpacingAfter(5.0f);
        if (iconName != null) {
            paragraph.add((Object)new Chunk(this.pdfDocumentFactory.getParagraphImage(iconName), 0.0f, -5.0f));
        }
        Phrase element = new Phrase(' ' + paragraphTitle, PdfDocumentFactory.PARAGRAPH_TITLE_FONT);
        element.setLeading(12.0f);
        paragraph.add((Object)element);
        ChapterAutoNumber chapter = new ChapterAutoNumber(paragraph);
        chapter.setNumberDepth(0);
        chapter.setBookmarkOpen(false);
        chapter.setTriggerNewPage(false);
        this.add((Element)chapter);
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private void add(Element element) throws DocumentException {
        this.document.add(element);
    }
}

