/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterError;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.PeriodCounterFactory;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Collector {
    private final int periodMillis;
    private final Timer timer;
    private final String application;
    private final List<Counter> counters;
    private final Map<String, JRobin> requestJRobinsById = new ConcurrentHashMap<String, JRobin>();
    private final Map<String, JRobin> counterJRobins = new LinkedHashMap<String, JRobin>();
    private final Map<Counter, CounterRequest> globalRequestsByCounter = new HashMap<Counter, CounterRequest>();
    private final Map<String, CounterRequest> requestsById = new HashMap<String, CounterRequest>();
    private final Map<Counter, Counter> dayCountersByCounter = new LinkedHashMap<Counter, Counter>();
    private long cpuTimeMillis;
    private long gcTimeMillis;
    private long lastCollectDuration;
    private long estimatedMemorySize;
    private final boolean noDatabase = Parameters.isNoDatabase();

    Collector(String application, List<Counter> counters, Timer timer) {
        assert (application != null);
        assert (counters != null);
        assert (timer != null);
        this.timer = timer;
        this.application = application;
        this.counters = Collections.unmodifiableList(new ArrayList<Counter>(counters));
        for (Counter counter : counters) {
            for (Counter otherCounter : counters) {
                assert (counter == otherCounter || !counter.getName().equals(otherCounter.getName()));
            }
            counter.setApplication(application);
            Counter dayCounter = new PeriodCounterFactory(counter).createDayCounterAtDate(new Date());
            this.dayCountersByCounter.put(counter, dayCounter);
        }
        this.periodMillis = Parameters.getResolutionSeconds() * 1000;
        try {
            for (Counter counter : counters) {
                counter.readFromFile();
            }
            for (Counter counter : counters) {
                this.dayCountersByCounter.get(counter).readFromFile();
            }
        }
        catch (IOException e) {
            Collector.printStackTrace(e);
        }
    }

    String getApplication() {
        return this.application;
    }

    List<Counter> getCounters() {
        return this.counters;
    }

    List<CounterRequestContext> getRootCurrentContexts() {
        ArrayList<CounterRequestContext> rootCurrentContexts = new ArrayList<CounterRequestContext>();
        for (Counter counter : this.counters) {
            if (!counter.isDisplayed()) continue;
            rootCurrentContexts.addAll(counter.getOrderedRootCurrentContexts());
        }
        if (rootCurrentContexts.size() > 1) {
            Collections.sort(rootCurrentContexts, Collections.reverseOrder(new Counter.CounterRequestContextComparator(System.currentTimeMillis())));
        }
        return rootCurrentContexts;
    }

    long getLastCollectDuration() {
        return this.lastCollectDuration;
    }

    long getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    private List<Counter> getPeriodCounters(Period period) throws IOException {
        Collection<Counter> currentDayCounters = this.dayCountersByCounter.values();
        ArrayList<Counter> result = new ArrayList<Counter>(currentDayCounters.size());
        switch (period) {
            case JOUR: {
                result.addAll(currentDayCounters);
                break;
            }
            case SEMAINE: {
                for (Counter dayCounter : currentDayCounters) {
                    result.add(new PeriodCounterFactory(dayCounter).getWeekCounter());
                }
                break;
            }
            case MOIS: {
                for (Counter dayCounter : currentDayCounters) {
                    result.add(new PeriodCounterFactory(dayCounter).getMonthCounter());
                }
                break;
            }
            case ANNEE: {
                for (Counter dayCounter : currentDayCounters) {
                    result.add(new PeriodCounterFactory(dayCounter).getYearCounter());
                }
                break;
            }
            case TOUT: {
                result.addAll(this.counters);
                break;
            }
            default: {
                throw new IllegalArgumentException(period.toString());
            }
        }
        return result;
    }

    List<Counter> getPeriodCountersToBeDisplayed(Period period) throws IOException {
        ArrayList<Counter> result = new ArrayList<Counter>(this.getPeriodCounters(period));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Counter counter = (Counter)it.next();
            if (counter.isDisplayed()) continue;
            it.remove();
        }
        return Collections.unmodifiableList(result);
    }

    void collectLocalContextWithoutErrors() {
        JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), false);
        this.collectWithoutErrors(Collections.singletonList(javaInformations));
    }

    void collectWithoutErrors(List<JavaInformations> javaInformationsList) {
        assert (javaInformationsList != null);
        long start = System.currentTimeMillis();
        try {
            this.estimatedMemorySize = this.collect(javaInformationsList);
        }
        catch (Throwable t) {
            Collector.printStackTrace(t);
        }
        this.lastCollectDuration = Math.max(0L, System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collect(List<JavaInformations> javaInformationsList) throws IOException {
        Collector collector = this;
        synchronized (collector) {
            if (!javaInformationsList.isEmpty()) {
                this.collectJavaInformations(javaInformationsList);
            }
            long memorySize = 0L;
            for (Counter counter : this.counters) {
                if (!counter.isDisplayed()) continue;
                memorySize += this.collectCounterData(counter);
            }
            return memorySize;
        }
    }

    private void collectJavaInformations(List<JavaInformations> javaInformationsList) throws IOException {
        long usedMemory = 0L;
        long processesCpuTimeMillis = 0L;
        long garbageCollectionTimeMillis = 0L;
        int availableProcessors = 0;
        long sessionCount = 0L;
        long activeThreadCount = 0L;
        long activeConnectionCount = 0L;
        long usedConnectionCount = 0L;
        double systemLoadAverage = 0.0;
        long unixOpenFileDescriptorCount = 0L;
        for (JavaInformations javaInformations : javaInformationsList) {
            usedMemory += javaInformations.getMemoryInformations().getUsedMemory();
            sessionCount = javaInformations.getSessionCount() >= 0 ? (sessionCount += (long)javaInformations.getSessionCount()) : -1L;
            activeThreadCount += (long)javaInformations.getActiveThreadCount();
            activeConnectionCount += (long)javaInformations.getActiveConnectionCount();
            usedConnectionCount += (long)javaInformations.getUsedConnectionCount();
            availableProcessors += javaInformations.getAvailableProcessors();
            processesCpuTimeMillis = javaInformations.getProcessCpuTimeMillis() >= 0L ? (processesCpuTimeMillis += javaInformations.getProcessCpuTimeMillis()) : -1L;
            garbageCollectionTimeMillis = javaInformations.getMemoryInformations().getGarbageCollectionTimeMillis() >= 0L ? (garbageCollectionTimeMillis += javaInformations.getMemoryInformations().getGarbageCollectionTimeMillis()) : -1L;
            systemLoadAverage = javaInformations.getSystemLoadAverage() >= 0.0 ? (systemLoadAverage += javaInformations.getSystemLoadAverage()) : -1.0;
            if (javaInformations.getUnixOpenFileDescriptorCount() >= 0L) {
                unixOpenFileDescriptorCount += javaInformations.getUnixOpenFileDescriptorCount();
                continue;
            }
            unixOpenFileDescriptorCount = -1L;
        }
        this.getCounterJRobin("usedMemory").addValue(usedMemory);
        availableProcessors = Math.max(availableProcessors, 1);
        this.collectCpu(processesCpuTimeMillis, availableProcessors);
        if (sessionCount >= 0L) {
            this.getCounterJRobin("httpSessions").addValue(sessionCount);
        }
        this.collectForNix(systemLoadAverage, garbageCollectionTimeMillis, availableProcessors, unixOpenFileDescriptorCount);
        this.getCounterJRobin("activeThreads").addValue(activeThreadCount);
        if (!this.noDatabase) {
            this.getCounterJRobin("activeConnections").addValue(activeConnectionCount);
            this.getCounterJRobin("usedConnections").addValue(usedConnectionCount);
        }
    }

    private void collectCpu(long processesCpuTimeMillis, int availableProcessors) throws IOException {
        if (processesCpuTimeMillis >= 0L) {
            int cpuPercentage = Math.min((int)((processesCpuTimeMillis - this.cpuTimeMillis) * 100L / (long)this.periodMillis / (long)availableProcessors), 100);
            this.getCounterJRobin("cpu").addValue(cpuPercentage);
            this.cpuTimeMillis = processesCpuTimeMillis;
        }
    }

    private void collectForNix(double systemLoadAverage, long garbageCollectionTimeMillis, int availableProcessors, long unixOpenFileDescriptorCount) throws IOException {
        if (systemLoadAverage >= 0.0) {
            this.getCounterJRobin("systemLoad").addValue(systemLoadAverage);
            if (garbageCollectionTimeMillis >= 0L) {
                int gcPercentage = Math.min((int)((garbageCollectionTimeMillis - this.gcTimeMillis) * 100L / (long)this.periodMillis / (long)availableProcessors), 100);
                this.getCounterJRobin("gc").addValue(gcPercentage);
                this.gcTimeMillis = garbageCollectionTimeMillis;
            }
            if (unixOpenFileDescriptorCount >= 0L) {
                this.getCounterJRobin("fileDescriptors").addValue(unixOpenFileDescriptorCount);
            }
        }
    }

    private long collectCounterData(Counter counter) throws IOException {
        String counterName = counter.getName();
        boolean errorCounter = counter.isErrorCounter();
        List<CounterRequest> requests = counter.getRequests();
        if (!errorCounter) {
            CounterRequest newGlobalRequest = new CounterRequest(counterName + " global", counterName);
            for (CounterRequest request : requests) {
                newGlobalRequest.addHits(request);
            }
            JRobin hitsJRobin = this.getCounterJRobin(counterName + "HitsRate");
            JRobin meanTimesJRobin = this.getCounterJRobin(counterName + "MeanTimes");
            JRobin systemErrorsJRobin = this.getCounterJRobin(counterName + "SystemErrors");
            CounterRequest globalRequest = this.globalRequestsByCounter.get(counter);
            if (globalRequest != null) {
                CounterRequest lastPeriodGlobalRequest = newGlobalRequest.clone();
                lastPeriodGlobalRequest.removeHits(globalRequest);
                long hits = lastPeriodGlobalRequest.getHits();
                long hitsParMinute = hits * 60L * 1000L / (long)this.periodMillis;
                hitsJRobin.addValue(hitsParMinute);
                if (hits > 0L) {
                    meanTimesJRobin.addValue(lastPeriodGlobalRequest.getMean());
                    systemErrorsJRobin.addValue(lastPeriodGlobalRequest.getSystemErrorPercentage());
                    counter.writeToFile();
                }
            }
            this.globalRequestsByCounter.put(counter, newGlobalRequest);
        }
        long dayCounterEstimatedMemorySize = this.collectCounterRequestsAndErrorsData(counter, requests);
        return counter.getEstimatedMemorySize() + dayCounterEstimatedMemorySize;
    }

    private long collectCounterRequestsAndErrorsData(Counter counter, List<CounterRequest> requests) throws IOException {
        boolean errorCounter = counter.isErrorCounter();
        int size = requests.size();
        Counter dayCounter = this.getCurrentDayCounter(counter);
        int maxRequestsCount = counter.getMaxRequestsCount();
        for (CounterRequest newRequest : requests) {
            if (size > maxRequestsCount && newRequest.getHits() < 10L) {
                this.removeRequest(counter, newRequest);
                --size;
                continue;
            }
            String requestStorageId = newRequest.getId();
            JRobin requestJRobin = this.getRequestJRobin(requestStorageId, newRequest.getName());
            CounterRequest request = this.requestsById.get(requestStorageId);
            if (request != null) {
                CounterRequest lastPeriodRequest = newRequest.clone();
                lastPeriodRequest.removeHits(request);
                if (lastPeriodRequest.getHits() > 0L) {
                    if (errorCounter) {
                        requestJRobin.addValue(lastPeriodRequest.getHits());
                    } else {
                        requestJRobin.addValue(lastPeriodRequest.getMean());
                    }
                    dayCounter.addHits(lastPeriodRequest);
                }
            }
            this.requestsById.put(requestStorageId, newRequest);
        }
        if (dayCounter.isErrorCounter()) {
            dayCounter.addErrors(this.getDeltaOfErrors(counter, dayCounter));
        }
        dayCounter.writeToFile();
        return dayCounter.getEstimatedMemorySize();
    }

    private List<CounterError> getDeltaOfErrors(Counter counter, Counter dayCounter) {
        List<CounterError> errors = counter.getErrors();
        if (errors.isEmpty()) {
            return Collections.emptyList();
        }
        List<CounterError> dayErrors = dayCounter.getErrors();
        long lastErrorTime = dayErrors.isEmpty() ? dayCounter.getStartDate().getTime() : dayErrors.get(dayErrors.size() - 1).getTime();
        ArrayList<CounterError> errorsOfDay = new ArrayList<CounterError>();
        for (CounterError error : errors) {
            if (error.getTime() <= lastErrorTime) continue;
            errorsOfDay.add(error);
        }
        return errorsOfDay;
    }

    private Counter getCurrentDayCounter(Counter counter) throws IOException {
        Counter dayCounter = this.dayCountersByCounter.get(counter);
        Calendar calendar = Calendar.getInstance();
        int currentDayOfYear = calendar.get(6);
        calendar.setTime(dayCounter.getStartDate());
        if (calendar.get(6) != currentDayOfYear) {
            dayCounter = new PeriodCounterFactory(dayCounter).buildNewDayCounter();
            this.dayCountersByCounter.put(counter, dayCounter);
        }
        return dayCounter;
    }

    private void removeRequest(Counter counter, CounterRequest newRequest) {
        counter.removeRequest(newRequest.getName());
        this.requestsById.remove(newRequest.getId());
        JRobin requestJRobin = this.requestJRobinsById.remove(newRequest.getId());
        if (requestJRobin != null) {
            requestJRobin.deleteFile();
        }
    }

    private JRobin getRequestJRobin(String requestId, String requestName) throws IOException {
        JRobin jrobin = this.requestJRobinsById.get(requestId);
        if (jrobin == null) {
            jrobin = JRobin.createInstance(this.getApplication(), requestId, requestName);
            this.requestJRobinsById.put(requestId, jrobin);
        }
        return jrobin;
    }

    private JRobin getCounterJRobin(String name) throws IOException {
        JRobin jrobin = this.counterJRobins.get(name);
        if (jrobin == null) {
            jrobin = JRobin.createInstance(this.getApplication(), name, null);
            this.counterJRobins.put(name, jrobin);
        }
        return jrobin;
    }

    JRobin getJRobin(String graphName) {
        JRobin jrobin = this.counterJRobins.get(graphName);
        if (jrobin == null && (jrobin = this.requestJRobinsById.get(graphName)) == null) {
            return null;
        }
        return jrobin;
    }

    Collection<JRobin> getCounterJRobins() {
        return Collections.unmodifiableCollection(this.counterJRobins.values());
    }

    void clearCounter(String counterName) {
        for (Counter counter : this.counters) {
            if (!counter.getName().equalsIgnoreCase(counterName)) continue;
            List<CounterRequest> requests = counter.getRequests();
            counter.clear();
            this.globalRequestsByCounter.remove(counter);
            for (CounterRequest request : requests) {
                this.requestsById.remove(request.getId());
                this.requestJRobinsById.remove(request.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        try {
            this.timer.cancel();
            for (Counter counter : this.counters) {
                counter.writeToFile();
            }
        }
        catch (IOException e) {
            Collector.printStackTrace(e);
        }
        finally {
            for (Counter counter : this.counters) {
                counter.clear();
            }
        }
    }

    static void stopJRobin() {
        if (Boolean.parseBoolean(System.getProperty("javamelody.jrobinStopDisabled"))) {
            return;
        }
        try {
            JRobin.stop();
        }
        catch (Throwable t) {
            Collector.printStackTrace(t);
        }
    }

    static void detachVirtualMachine() {
        try {
            VirtualMachine.detach();
        }
        catch (Throwable t) {
            Collector.printStackTrace(t);
        }
    }

    static void printStackTrace(Throwable t) {
        t.printStackTrace(System.err);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[application=" + this.getApplication() + ", periodMillis=" + this.periodMillis + ", counters=" + this.getCounters() + ']';
    }
}

