/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Pattern;
import net.authorize.util.SensitiveDataConfigType;
import net.authorize.util.SensitiveTagsDeserializer;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="SensitiveFilterPatternConverter", category="Converter")
@ConverterKeys(value={"maskedMessage"})
public class SensitiveFilterPatternConverter
extends LogEventPatternConverter {
    private static Pattern[] cardPatterns;
    private static Pattern[] tagPatterns;
    private static String[] tagReplacements;
    private static Gson gson;

    private SensitiveFilterPatternConverter(String name, String style) {
        super(name, style);
        this.initialize();
    }

    public static SensitiveFilterPatternConverter newInstance(String[] options) {
        return new SensitiveFilterPatternConverter("maskedMessage", "maskedMessage");
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        try {
            String message = event.getMessage().getFormattedMessage();
            String maskXmlMessage = SensitiveFilterPatternConverter.maskSensitiveXmlString(message);
            String maskCardNumber = SensitiveFilterPatternConverter.maskCreditCards(maskXmlMessage);
            toAppendTo.append(maskCardNumber.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize() {
        try {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(SensitiveDataConfigType.class, (Object)new SensitiveTagsDeserializer());
            gson = gsonBuilder.create();
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/AuthorizedNetSensitiveTagsConfig.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            SensitiveDataConfigType configType = (SensitiveDataConfigType)gson.fromJson((Reader)reader, SensitiveDataConfigType.class);
            cardPatterns = new Pattern[configType.sensitiveStringRegexes.length];
            for (int i = 0; i < configType.sensitiveStringRegexes.length; ++i) {
                SensitiveFilterPatternConverter.cardPatterns[i] = Pattern.compile(configType.sensitiveStringRegexes[i]);
            }
            int noOfSensitiveTags = configType.sensitiveTags.length;
            tagPatterns = new Pattern[noOfSensitiveTags];
            tagReplacements = new String[noOfSensitiveTags];
            for (int j = 0; j < noOfSensitiveTags; ++j) {
                String tagName = configType.sensitiveTags[j].tagName;
                String pattern = configType.sensitiveTags[j].pattern;
                String replacement = configType.sensitiveTags[j].replacement;
                SensitiveFilterPatternConverter.tagPatterns[j] = pattern != null && !pattern.isEmpty() ? Pattern.compile("<" + tagName + ">" + pattern + "</" + tagName + ">") : Pattern.compile("<" + tagName + ">.+</" + tagName + ">");
                SensitiveFilterPatternConverter.tagReplacements[j] = "<" + tagName + ">" + replacement + "</" + tagName + ">";
            }
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String maskCreditCards(String str) {
        for (int i = 0; i < cardPatterns.length; ++i) {
            str = cardPatterns[i].matcher(str).replaceAll("XXXX");
        }
        return str;
    }

    public static String maskSensitiveXmlString(String str) {
        for (int i = 0; i < tagPatterns.length; ++i) {
            str = tagPatterns[i].matcher(str).replaceAll(tagReplacements[i]);
        }
        return str;
    }
}

