/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import net.authorize.data.OrderItem;
import net.authorize.data.ShippingCharges;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@Deprecated
public class Order
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(Order.class);
    public static final int MAX_INVOICE_NUMBER_LENGTH = 20;
    public static final int MAX_DESCRIPTION_LENGTH = 255;
    public static final int MAX_ORDER_ITEM_SIZE = 30;
    protected String invoiceNumber;
    protected String purchaseOrderNumber;
    protected String description;
    protected BigDecimal totalAmount = new BigDecimal(0.0);
    protected ShippingCharges shippingCharges;
    protected List<OrderItem> orderItems = new ArrayList<OrderItem>();

    protected Order() {
    }

    public static Order createOrder() {
        return new Order();
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public List<OrderItem> getOrderItems() {
        return this.orderItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderItems(List<OrderItem> orderItems) {
        Order order = this;
        synchronized (order) {
            int itemListMax = orderItems.size() > 30 ? 30 : orderItems.size();
            try {
                this.orderItems = new ArrayList<OrderItem>(orderItems.subList(0, itemListMax));
            }
            catch (Exception e) {
                logger.warn((Object)"Failed setting orderItems.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrderItem(OrderItem orderItem) {
        Order order = this;
        synchronized (order) {
            if (this.orderItems.size() < 30) {
                this.orderItems.add(orderItem);
            }
        }
    }

    public ShippingCharges getShippingCharges() {
        return this.shippingCharges;
    }

    public void setShippingCharges(ShippingCharges shippingCharges) {
        this.shippingCharges = shippingCharges;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }
}

