/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.authorize.util.XmlTreeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicXmlDocument
implements Serializable {
    private static final long serialVersionUID = 1L;
    Document document;
    private String sourceFile;
    private boolean accessible = false;
    DocumentBuilderFactory dbf;
    DocumentBuilder db;
    private long xmlParseTime = -1L;
    private String resolve_path = null;
    private ArrayList<String> errors = new ArrayList();

    public BasicXmlDocument() {
        this.initClass();
    }

    public BasicXmlDocument(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    private void initClass() {
        try {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.db = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.out.println("Error in parsing: " + e);
        }
    }

    public void setResolvePath(String p) {
        this.resolve_path = p;
    }

    public long getParseTime() {
        return this.xmlParseTime;
    }

    public boolean IsAccessible() {
        return this.accessible;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public Element createElement(String name) {
        return this.document.createElement(name);
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public void addError(String message) {
        this.errors.add(message);
        System.out.println(message);
    }

    public boolean removeChildren(Node ref) {
        boolean ret = false;
        if (ref == null || !ref.hasChildNodes()) {
            return ret;
        }
        for (int i = ref.getChildNodes().getLength() - 1; i >= 0; --i) {
            Node child = ref.getChildNodes().item(i);
            ref.removeChild(child);
        }
        ret = true;
        return ret;
    }

    public boolean parse() {
        return this.parse(this.sourceFile);
    }

    public boolean parse(String xmlFile) {
        File f = new File(xmlFile);
        if (!f.exists()) {
            this.addError("parse(String xmlFile):: File " + f.getAbsolutePath() + " does not exist");
            return false;
        }
        this.sourceFile = xmlFile;
        return this.parse(f);
    }

    public void saveDocument(String fileName) {
        try {
            File f = new File(fileName);
            FileOutputStream fileOut = new FileOutputStream(f);
            XmlTreeUtil xtu = new XmlTreeUtil();
            xtu.printTree(this.document, fileOut);
            fileOut.close();
        }
        catch (IOException e) {
            this.addError("saveDocument(String fileName):: " + e.toString());
            e.printStackTrace();
        }
    }

    public boolean parse(File in_file) {
        boolean returnType = false;
        try {
            FileInputStream fis = new FileInputStream(in_file);
            returnType = this.parse(fis);
            fis.close();
        }
        catch (IOException e) {
            this.addError("parse(File in_file):: " + e.toString());
        }
        return returnType;
    }

    public boolean parse(InputStream in) {
        boolean returnType = false;
        try {
            long start = System.currentTimeMillis();
            this.db.setEntityResolver(new BasicXmlDocumentEntityResolver(this));
            this.document = this.db.parse(in);
            long stop = System.currentTimeMillis();
            this.xmlParseTime = stop - start;
            this.accessible = true;
            returnType = true;
        }
        catch (IOException e) {
            this.addError("parse(InputStream in):: " + e.toString());
        }
        catch (SAXException e) {
            this.addError("parse(InputStream in):: " + e.toString());
        }
        return returnType;
    }

    public boolean parseString(String xmlValue) {
        return this.parse(new ByteArrayInputStream(xmlValue.getBytes()));
    }

    public boolean parseBytes(byte[] xmlBytes) {
        return this.parse(new ByteArrayInputStream(xmlBytes));
    }

    public String dump() {
        return this.dump(true);
    }

    public String dump(boolean collapse) {
        XmlTreeUtil xtu = new XmlTreeUtil();
        if (collapse) {
            xtu.setCollapsed();
        }
        return xtu.printTree(this.document);
    }

    public boolean dumpToDisk(String fileName) {
        return this.dumpToDisk(fileName, true);
    }

    public boolean dumpToDisk(String fileName, boolean collapse) {
        try {
            File f = new File(fileName);
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(this.dump(collapse).getBytes());
            fos.close();
            return true;
        }
        catch (IOException e) {
            this.addError("dumpToDisk(String fileName):: " + e.toString());
            return false;
        }
    }

    public static String getElementText(Element parent_el, String element_name) {
        String out_val = null;
        NodeList match_list = parent_el.getElementsByTagName(element_name);
        if (match_list.getLength() == 0) {
            return out_val;
        }
        Element match_el = (Element)match_list.item(0);
        if (match_el.hasChildNodes()) {
            out_val = match_el.getFirstChild().getNodeValue();
        }
        return out_val;
    }

    class BasicXMLDocumentErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException spe_error) {
            System.out.println("SAXParseException Error: " + spe_error.toString() + " / " + spe_error.getPublicId());
        }

        public void fatalError(SAXParseException spe_fatal) {
            System.out.println("SAXParseException Fatal: " + spe_fatal.toString());
        }

        public void warning(SAXParseException spe_warn) {
            System.out.println("SAXParseException Warning: " + spe_warn.toString());
        }
    }

    class BasicXmlDocumentEntityResolver
    implements EntityResolver {
        private BasicXmlDocument xml_document = null;

        public BasicXmlDocumentEntityResolver(BasicXmlDocument xml_document) {
            this.xml_document = xml_document;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (BasicXmlDocument.this.resolve_path == null) {
                return null;
            }
            return null;
        }
    }
}

