/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.util;

import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Scanner;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import net.authorize.acceptsdk.util.SDKCurrency;

public class SDKUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "hh:mm a";
    private static final String DEFAULT_TIMEZONE = "America/Los_Angeles";
    private static final String UTC_TIMEZONE = "UTC";
    private static final String BASIC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final int CONNECTION_ATTEPTS = 5;
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int RECIEVE_DATA_TIMEOUT = 30000;
    private static final int PORT_80 = 80;
    private static final int PORT_443 = 443;

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is);
        s.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        s.close();
        return result;
    }

    public static String convertTimeInMilisToDate(String timeStamp, String timezone) {
        return SDKUtils.getTime(timeStamp, timezone, DATE_FORMAT);
    }

    public static String convertTimeInMilisToTime(String timeStamp, String timezone) {
        return SDKUtils.getTime(timeStamp, timezone, TIME_FORMAT);
    }

    private static String getTime(String timeStamp, String timezone, String format) {
        TimeZone utc = TimeZone.getTimeZone(UTC_TIMEZONE);
        long time = SDKUtils.stringToLong(timeStamp);
        TimeZone timeZone = !TextUtils.isEmpty((CharSequence)timezone) ? TimeZone.getTimeZone(timezone) : TimeZone.getTimeZone(DEFAULT_TIMEZONE);
        SimpleDateFormat sdf = new SimpleDateFormat(BASIC_DATE_FORMAT);
        sdf.setTimeZone(timeZone);
        Date date = new Date(time);
        String input = sdf.format(date);
        GregorianCalendar cal = new GregorianCalendar(utc);
        try {
            SimpleDateFormat s = new SimpleDateFormat(BASIC_DATE_FORMAT);
            s.setTimeZone(utc);
            cal.setTime(s.parse(input));
            Date date2 = new Date(cal.getTime().getTime());
            SimpleDateFormat simpleDate = new SimpleDateFormat(format);
            return simpleDate.format(date2);
        }
        catch (ParseException e) {
            return input;
        }
    }

    public static String convertToLocalTime(String input) {
        return SDKUtils.getTime(input, TIME_FORMAT);
    }

    public static String convertToLocalDate(String input) {
        return SDKUtils.getTime(input, DATE_FORMAT);
    }

    private static String getTime(String input, String format) {
        TimeZone utc = TimeZone.getTimeZone(UTC_TIMEZONE);
        SimpleDateFormat f = new SimpleDateFormat(BASIC_DATE_FORMAT);
        f.setTimeZone(utc);
        GregorianCalendar cal = new GregorianCalendar(utc);
        try {
            cal.setTime(f.parse(input));
            Date date = new Date(cal.getTime().getTime());
            SimpleDateFormat simpleDate = new SimpleDateFormat(format);
            return simpleDate.format(date);
        }
        catch (ParseException e) {
            return input;
        }
    }

    public static long stringToLong(String value) {
        long result = 0L;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException exception) {
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static HttpsURLConnection getHttpsURLConnection(String urlString, String requestMethod, boolean doOutput) throws IOException {
        URL url = new URL(urlString);
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        SSLSocketFactory socketFactory = SDKUtils.getSSLSocketFactory();
        if (socketFactory != null) {
            urlConnection.setSSLSocketFactory(SDKUtils.getSSLSocketFactory());
        }
        if (requestMethod != null) {
            urlConnection.setRequestMethod(requestMethod);
        }
        urlConnection.setConnectTimeout(10000);
        urlConnection.setReadTimeout(30000);
        urlConnection.setDoOutput(doOutput);
        urlConnection.setDoInput(true);
        return urlConnection;
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(null, null, new SecureRandom());
            return context.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static SDKCurrency getSDKCurrencyFromString(String currencyString) {
        switch (currencyString) {
            case "USD": {
                return SDKCurrency.USD;
            }
            case "CAD": {
                return SDKCurrency.CAD;
            }
            case "EUR": {
                return SDKCurrency.EUR;
            }
            case "GBP": {
                return SDKCurrency.GBP;
            }
        }
        return null;
    }

    public static String getAmountStringFromBigDecimal(BigDecimal value) {
        BigDecimal amount = value.setScale(2, RoundingMode.CEILING);
        return amount.toPlainString();
    }
}

