/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.network;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Xml;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import javax.net.ssl.HttpsURLConnection;
import net.authorize.acceptsdk.datamodel.error.SDKErrorCode;
import net.authorize.acceptsdk.datamodel.transaction.EncryptTransactionObject;
import net.authorize.acceptsdk.datamodel.transaction.response.EncryptTransactionResponse;
import net.authorize.acceptsdk.datamodel.transaction.response.ErrorTransactionResponse;
import net.authorize.acceptsdk.datamodel.transaction.response.TransactionResponse;
import net.authorize.acceptsdk.network.ConnectionData;
import net.authorize.acceptsdk.network.TransactionResultReceiver;
import net.authorize.acceptsdk.parser.AcceptSDKParser;
import net.authorize.acceptsdk.util.LogUtil;
import net.authorize.acceptsdk.util.SDKUtils;
import org.json.JSONException;

public class AcceptService
extends IntentService {
    private static final String POST = "POST";
    public static final String ACTION_ENCRYPT = "net.authorize.action.ENCRYPT";
    private static final String EXTRA_PARAM_TRANSACTION_OBJECT = "net.authorize.extra.TRANSACTION_OBJECT";
    private static final String EXTRA_PARAM_RESULT_RECEIVER = "net.authorize.extra.RESULT_RECEIVER";
    public static final String SERVICE_RESULT_RESPONSE_KEY = "SERVICE_RESULT_RESPONSE_KEY";
    public static final String SERVICE_RESULT_ERROR_KEY = "SERVICE_RESULT_ERROR_KEY";
    public static final int SERVICE_RESULT_CODE_SDK_RESPONSE = 100;
    public static final int SERVICE_RESULT_CODE_SDK_ERROR = 200;

    public static void startActionEncrypt(Context context, EncryptTransactionObject transactionObject, TransactionResultReceiver resultReceiver) {
        Intent intent = new Intent(context, AcceptService.class);
        intent.setAction(ACTION_ENCRYPT);
        Bundle bundle = new Bundle();
        bundle.putSerializable(EXTRA_PARAM_TRANSACTION_OBJECT, (Serializable)transactionObject);
        bundle.putParcelable(EXTRA_PARAM_RESULT_RECEIVER, (Parcelable)resultReceiver);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public AcceptService() {
        super("InAppConnectionService");
    }

    protected void onHandleIntent(Intent intent) {
        if (intent != null) {
            String action;
            switch (action = intent.getAction()) {
                case "net.authorize.action.ENCRYPT": {
                    EncryptTransactionObject transactionObject = (EncryptTransactionObject)intent.getSerializableExtra(EXTRA_PARAM_TRANSACTION_OBJECT);
                    ResultReceiver resultReceiver = (ResultReceiver)intent.getParcelableExtra(EXTRA_PARAM_RESULT_RECEIVER);
                    Object result = this.handleActionEncrypt(transactionObject);
                    this.onPostHandleAction(result, resultReceiver);
                }
            }
        }
    }

    private Object handleActionEncrypt(EncryptTransactionObject transactionObject) {
        TransactionResponse resultObject = null;
        String url = ConnectionData.getActiveEndPointUrl();
        try {
            HttpsURLConnection urlConnection = SDKUtils.getHttpsURLConnection(url, POST, true);
            urlConnection.setRequestProperty("Content-type", "application/json");
            urlConnection.setConnectTimeout(ConnectionData.getConnectionTimeout());
            OutputStream os = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, Xml.Encoding.UTF_8.name()));
            writer.write(AcceptSDKParser.getOrderedJsonFromEncryptTransaction(transactionObject));
            writer.flush();
            writer.close();
            os.close();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                String responseString = SDKUtils.convertStreamToString(urlConnection.getInputStream());
                LogUtil.log(LogUtil.LOG_LEVEL.INFO, " response string :" + responseString);
                TransactionResponse response = AcceptSDKParser.createEncryptionTransactionResponse(responseString);
                resultObject = response.getResultCode().equals("Ok") ? response : response;
            } else {
                resultObject = responseCode == 500 ? ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_02.getErrorCode(), urlConnection.getErrorStream()) : ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_02);
            }
        }
        catch (SocketTimeoutException e) {
            resultObject = ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_02, e.getMessage());
        }
        catch (IOException e) {
            resultObject = ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_02, e.getMessage());
        }
        catch (JSONException e) {
            resultObject = ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_14, e.getMessage());
        }
        return resultObject;
    }

    protected void onPostHandleAction(Object result, ResultReceiver resultReceiver) {
        Bundle resultData = new Bundle();
        if (result instanceof EncryptTransactionResponse) {
            EncryptTransactionResponse response = (EncryptTransactionResponse)result;
            resultData.putParcelable(SERVICE_RESULT_RESPONSE_KEY, (Parcelable)response);
            resultReceiver.send(100, resultData);
        } else if (result instanceof ErrorTransactionResponse) {
            ErrorTransactionResponse response = (ErrorTransactionResponse)result;
            resultData.putParcelable(SERVICE_RESULT_ERROR_KEY, (Parcelable)response);
            resultReceiver.send(200, resultData);
        }
    }
}

