/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.datamodel.transaction.response;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.authorize.acceptsdk.datamodel.common.Message;
import net.authorize.acceptsdk.datamodel.common.ResponseMessages;
import net.authorize.acceptsdk.datamodel.error.SDKErrorCode;
import net.authorize.acceptsdk.datamodel.transaction.response.TransactionResponse;
import net.authorize.acceptsdk.util.LogUtil;
import net.authorize.acceptsdk.util.SDKUtils;

public class ErrorTransactionResponse
extends TransactionResponse {
    public static final Parcelable.Creator<ErrorTransactionResponse> CREATOR = new Parcelable.Creator<ErrorTransactionResponse>(){

        public ErrorTransactionResponse createFromParcel(Parcel in) {
            return new ErrorTransactionResponse(in);
        }

        public ErrorTransactionResponse[] newArray(int size) {
            return new ErrorTransactionResponse[size];
        }
    };

    public ErrorTransactionResponse(ResponseMessages responseMessages) {
        super(responseMessages);
    }

    public static ErrorTransactionResponse createErrorResponse(Message errorMessage) {
        ResponseMessages responseMessages = new ResponseMessages("Error");
        responseMessages.addMessage(errorMessage);
        return new ErrorTransactionResponse(responseMessages);
    }

    public static ErrorTransactionResponse createErrorResponse(String errorCode, InputStream errorStream) throws IOException {
        String errorString = SDKUtils.convertStreamToString(errorStream);
        LogUtil.log(LogUtil.LOG_LEVEL.INFO, errorString);
        Message message = new Message(errorCode, errorString);
        return ErrorTransactionResponse.createErrorResponse(message);
    }

    public static ErrorTransactionResponse createErrorResponse(SDKErrorCode errorCode, String errorMessage) {
        Message message = new Message(errorCode.getErrorCode(), errorMessage);
        return ErrorTransactionResponse.createErrorResponse(message);
    }

    public static ErrorTransactionResponse createErrorResponse(SDKErrorCode errorCode) {
        Message message = new Message(errorCode.getErrorCode(), errorCode.getErrorMessage());
        return ErrorTransactionResponse.createErrorResponse(message);
    }

    public Message getFirstErrorMessage() {
        Message message = null;
        if (this.responseMessages == null) {
            return message;
        }
        List<Message> messageList = this.responseMessages.getMessageList();
        if (messageList != null && messageList.size() > 0) {
            message = messageList.get(0);
        }
        return message;
    }

    public ErrorTransactionResponse(Parcel in) {
        super(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }
}

