/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.datamodel.transaction;

import net.authorize.acceptsdk.ValidationCallback;
import net.authorize.acceptsdk.datamodel.error.SDKErrorCode;
import net.authorize.acceptsdk.datamodel.transaction.TransactionObject;
import net.authorize.acceptsdk.datamodel.transaction.TransactionType;
import net.authorize.acceptsdk.datamodel.transaction.response.ErrorTransactionResponse;

public class EncryptTransactionObject
extends TransactionObject {
    private EncryptTransactionObject(Builder builder) {
        this.mTransactionType = builder.transactionType;
        this.mCardData = builder.cardData;
        this.mMerchantAuthentication = builder.merchantAuthentication;
    }

    @Override
    public boolean validateTransactionObject(ValidationCallback callback) {
        if (this.mMerchantAuthentication == null) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_04));
            return false;
        }
        if (this.mCardData == null) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_04));
            return false;
        }
        if (this.mMerchantAuthentication.validateMerchantAuthentication(callback) && this.mCardData.validateCardData(callback)) {
            callback.OnValidationSuccessful();
            return true;
        }
        return false;
    }

    public static class Builder
    extends TransactionObject.Builder {
        public Builder() {
            this.transactionType = TransactionType.SDK_TRANSACTION_ENCRYPTION;
        }

        @Override
        public EncryptTransactionObject build() {
            return new EncryptTransactionObject(this);
        }
    }
}

