/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk;

import java.util.Calendar;

public class ValidationManager {
    public static boolean isValidCardNumber(String cardNumber) {
        if (cardNumber == null) {
            return false;
        }
        if ((cardNumber = cardNumber.trim()).length() < 6) {
            return false;
        }
        if (!cardNumber.matches("\\d+")) {
            return false;
        }
        String reversedNumber = new StringBuilder(cardNumber).reverse().toString();
        String mutilatedString = "";
        for (int i = 0; i < reversedNumber.length(); ++i) {
            int c = Integer.parseInt(String.valueOf(reversedNumber.charAt(i)));
            if (i % 2 != 0) {
                c *= 2;
            }
            mutilatedString = mutilatedString + c;
        }
        int sumOfDigits = 0;
        for (int i = 0; i < mutilatedString.length(); ++i) {
            int c = Integer.parseInt(String.valueOf(mutilatedString.charAt(i)));
            sumOfDigits += c;
        }
        return sumOfDigits > 0 && sumOfDigits % 10 == 0;
    }

    public static boolean isValidExpirationMonth(String month) {
        if (month == null || month.length() != 2 || !month.matches("\\d+")) {
            return false;
        }
        int checkMonth = Integer.parseInt(month);
        return checkMonth >= 1 && checkMonth <= 12;
    }

    public static boolean isValidExpirationYear(String year) {
        if (year == null || year.length() != 4) {
            return false;
        }
        return year.matches("\\d+");
    }

    public static boolean isValidExpirationDate(String month, String year) {
        int currentYear = Calendar.getInstance().get(1);
        int currentMonth = Calendar.getInstance().get(2) + 1;
        int checkYear = Integer.parseInt(year);
        int checkMonth = Integer.parseInt(month);
        if (checkYear < currentYear) {
            return false;
        }
        return checkYear != currentYear || checkMonth >= currentMonth;
    }

    public static boolean isValidCVV(String cvvCode) {
        if (cvvCode == null || cvvCode.length() < 3 || cvvCode.length() > 4) {
            return false;
        }
        return cvvCode.matches("\\d+");
    }

    public static boolean isValidZipCode(String zipCode) {
        return zipCode != null && zipCode.length() >= 1 && zipCode.length() <= 20;
    }

    public static boolean isValidCardHolderName(String fullName) {
        return fullName != null && fullName.length() >= 1 && fullName.length() <= 64;
    }

    public static boolean isValidAmount(double amount) {
        return !(amount <= 0.0);
    }

    public static boolean isValidTimeStamp(long timestamp) {
        return timestamp >= 0L;
    }

    public static boolean isValidString(String string) {
        return string != null && !string.isEmpty();
    }
}

