/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapConverter
implements Converter {
    public static final MapConverter INSTANCE = new MapConverter();

    MapConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Map.class.isAssignableFrom(cls);
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        Map map;
        Type pt0 = context.getParameterType(t, Map.class, 0);
        Type pt1 = context.getParameterType(t, Map.class, 1);
        Class<?> pc0 = ClassUtil.getRawType(pt0);
        Class<?> pc1 = ClassUtil.getRawType(pt1);
        if (value instanceof Map) {
            Map src = (Map)value;
            context.createSizeHint = src.size();
            map = (Map)context.createInternal(c);
            context.createSizeHint = -1;
            if (Object.class.equals(pc0) && Object.class.equals(pc1)) {
                map.putAll(src);
            } else {
                JSONHint hint = context.getHint();
                for (Map.Entry entry : src.entrySet()) {
                    Object key = context.postparseInternal(entry.getKey(), pc0, pt0);
                    context.enter(entry.getKey(), hint);
                    map.put(key, context.postparseInternal(entry.getValue(), pc1, pt1));
                    context.exit();
                }
            }
        } else if (value instanceof List) {
            List src = (List)value;
            context.createSizeHint = src.size();
            map = (Map)context.createInternal(c);
            context.createSizeHint = -1;
            if (Object.class.equals(pc0) && Object.class.equals(pc1)) {
                for (int i = 0; i < src.size(); ++i) {
                    map.put(i, src.get(i));
                }
            } else {
                JSONHint hint = context.getHint();
                for (int i = 0; i < src.size(); ++i) {
                    Object key = context.postparseInternal(i, pc0, pt0);
                    context.enter(i, hint);
                    map.put(key, context.postparseInternal(src.get(i), pc1, pt1));
                    context.exit();
                }
            }
        } else {
            String key;
            context.createSizeHint = 1;
            map = (Map)context.createInternal(c);
            context.createSizeHint = -1;
            JSONHint hint = context.getHint();
            String string = key = hint != null && hint.anonym().length() > 0 ? hint.anonym() : null;
            if (Object.class.equals(pc0) && Object.class.equals(pc1)) {
                map.put(value, null);
            } else {
                key = context.postparseInternal(key, pc0, pt0);
                context.enter(key, hint);
                map.put(key, context.postparseInternal(value, pc1, pt1));
                context.exit();
            }
        }
        return map;
    }
}

