/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class ElementNodeFormatter
implements Formatter {
    private static final Class<?>[] targets = new Class[]{Document.class, Element.class};

    public boolean accept(Object o) {
        for (Class<?> target : targets) {
            if (o == null || !target.isAssignableFrom(o.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isStruct() {
        return true;
    }

    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        if (o instanceof Document) {
            this.formatElement(context, src, ((Document)o).getDocumentElement(), out);
        } else {
            this.formatElement(context, src, (Element)o, out);
        }
    }

    public boolean formatElement(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        Element elem = (Element)o;
        out.append('[');
        StringFormatter.serialize(context, elem.getTagName(), out);
        out.append(',');
        if (context.isPrettyPrint()) {
            out.append('\n');
            context.appendIndent(out, context.getDepth() + 1);
        }
        out.append('{');
        if (elem.hasAttributes()) {
            NamedNodeMap names = elem.getAttributes();
            for (int i = 0; i < names.getLength(); ++i) {
                Node node;
                if (i != 0) {
                    out.append(',');
                }
                if (context.isPrettyPrint() && names.getLength() > 1) {
                    out.append('\n');
                    for (int j = 0; j < context.getDepth() + 2; ++j) {
                        out.append('\t');
                    }
                }
                if (!((node = names.item(i)) instanceof Attr)) continue;
                StringFormatter.serialize(context, node.getNodeName(), out);
                out.append(':');
                if (context.isPrettyPrint()) {
                    out.append(' ');
                }
                StringFormatter.serialize(context, node.getNodeValue(), out);
            }
            if (context.isPrettyPrint() && names.getLength() > 1) {
                out.append('\n');
                context.appendIndent(out, context.getDepth() + 1);
            }
        }
        out.append('}');
        if (elem.hasChildNodes()) {
            NodeList nodes = elem.getChildNodes();
            JSONHint hint = context.getHint();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Object value = nodes.item(i);
                if (!(value instanceof Element) && (!(value instanceof CharacterData) || value instanceof Comment)) continue;
                out.append(',');
                if (context.isPrettyPrint()) {
                    out.append('\n');
                    context.appendIndent(out, context.getDepth() + 1);
                }
                context.enter(i + 2, hint);
                value = context.preformatInternal(value);
                context.formatInternal(value, out);
                context.exit();
            }
        }
        if (context.isPrettyPrint()) {
            out.append('\n');
            context.appendIndent(out, context.getDepth());
        }
        out.append(']');
        return true;
    }
}

