/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import net.arnx.jsonic.io.InputSource;

public class ReaderInputSource
implements InputSource {
    private static int BACK = 20;
    private long lines = 1L;
    private long columns = 0L;
    private long offset = 0L;
    private InputStream in;
    private Reader reader;
    private final char[] buf = new char[1024];
    private int back = BACK;
    private int start = BACK;
    private int end = BACK - 1;
    private int mark = -1;

    public ReaderInputSource(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
    }

    public ReaderInputSource(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.reader = reader;
    }

    public int next() throws IOException {
        int n = -1;
        n = this.get();
        if (n != -1) {
            ++this.offset;
            if (n == 13) {
                ++this.lines;
                this.columns = 0L;
            } else if (n == 10) {
                if (this.start < 2 || this.buf[this.start - 2] != '\r') {
                    ++this.lines;
                    this.columns = 0L;
                }
            } else {
                ++this.columns;
            }
        }
        return n;
    }

    private int get() throws IOException {
        if (this.start > this.end) {
            int n;
            if (this.end > BACK) {
                n = Math.min(BACK, this.end - BACK + 1);
                System.arraycopy(this.buf, this.end + 1 - n, this.buf, BACK - n, n);
                this.back = BACK - n;
            }
            if (this.in != null) {
                if (!this.in.markSupported()) {
                    this.in = new PushbackInputStream(this.in);
                }
                this.reader = new InputStreamReader(this.in, ReaderInputSource.determineEncoding(this.in));
                this.in = null;
            }
            if ((n = this.reader.read(this.buf, BACK, this.buf.length - BACK)) != -1) {
                this.mark = this.mark > this.end - BACK ? BACK - (this.end - this.mark + 1) : -1;
                this.start = BACK;
                this.end = BACK + n - 1;
            } else {
                ++this.start;
                return -1;
            }
        }
        return this.buf[this.start++];
    }

    public void back() {
        if (this.start <= this.back) {
            throw new IllegalStateException("no backup charcter");
        }
        --this.start;
        if (this.start <= this.end) {
            --this.offset;
            --this.columns;
        }
    }

    public int mark() throws IOException {
        if (this.start > this.end) {
            int n = this.get();
            this.back();
            if (n == -1) {
                this.mark = -1;
                return 0;
            }
        }
        this.mark = this.start;
        return this.end - this.mark + 1;
    }

    public void copy(StringBuilder stringBuilder, int n) {
        if (this.mark == -1) {
            throw new IllegalStateException("no mark");
        }
        if (this.mark + n > this.end + 1) {
            throw new IndexOutOfBoundsException();
        }
        stringBuilder.append(this.buf, this.mark, n);
    }

    public String copy(int n) {
        if (this.mark == -1) {
            throw new IllegalStateException("no mark");
        }
        if (this.mark + n > this.end + 1) {
            throw new IndexOutOfBoundsException();
        }
        return String.valueOf(this.buf, this.mark, n);
    }

    public long getLineNumber() {
        return this.lines;
    }

    public long getColumnNumber() {
        return this.columns;
    }

    public long getOffset() {
        return this.offset;
    }

    private static String determineEncoding(InputStream inputStream) throws IOException {
        byte[] byArray;
        int n;
        String string = "UTF-8";
        if (inputStream.markSupported()) {
            inputStream.mark(4);
        }
        if ((n = inputStream.read(byArray = new byte[4])) == 2) {
            if ((byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) != 0 || (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
                string = "UTF-16BE";
            } else if ((byArray[0] & 0xFF) != 0 && (byArray[1] & 0xFF) == 0 || (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
                string = "UTF-16LE";
            }
        } else if (n == 4) {
            if ((byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 0) {
                string = "UTF-32BE";
            } else if ((byArray[2] & 0xFF) == 0 && (byArray[3] & 0xFF) == 0) {
                string = "UTF-32LE";
            } else if ((byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) != 0 || (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
                string = "UTF-16BE";
            } else if ((byArray[0] & 0xFF) != 0 && (byArray[1] & 0xFF) == 0 || (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
                string = "UTF-16LE";
            }
        }
        if (inputStream.markSupported()) {
            inputStream.reset();
        } else {
            ((PushbackInputStream)inputStream).unread(byArray, 0, n);
        }
        return string;
    }

    public String toString() {
        int n = this.back;
        int n2 = Math.min(this.start - 1, this.end);
        int n3 = 0;
        for (int i = 0; i < n2 + 1 - this.back && i < BACK; ++i) {
            char c = this.buf[n2 - i];
            if (c == '\r' || c == '\n' && (n2 - i - 1 < 0 || this.buf[n2 - i - 1] != '\r')) {
                if (n3 <= 0) continue;
                break;
            }
            if (c == '\n') continue;
            n = n2 - i;
            ++n3;
        }
        return n <= n2 ? String.valueOf(this.buf, n, n2 - n + 1) : "";
    }
}

