/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;

final class DynaBeanFormatter
implements Formatter {
    public static final DynaBeanFormatter INSTANCE = new DynaBeanFormatter();
    private static final Class<?> target = DynaBean.class;

    DynaBeanFormatter() {
    }

    public boolean accept(Object object) {
        return object != null && target.isAssignableFrom(object.getClass());
    }

    public boolean isStruct() {
        return true;
    }

    public void format(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        outputSource.append('{');
        int n = 0;
        String string = null;
        try {
            DynaBean dynaBean = (DynaBean)object2;
            DynaProperty[] dynaPropertyArray = dynaBean.getDynaClass().getDynaProperties();
            if (dynaPropertyArray == null) {
                dynaPropertyArray = new DynaProperty[]{};
            }
            JSONHint jSONHint = context.getHint();
            for (DynaProperty dynaProperty : dynaPropertyArray) {
                Object object3;
                string = dynaProperty.getName();
                if (string == null || (object3 = dynaBean.get(string)) == object || context.isSuppressNull() && object3 == null) continue;
                if (n != 0) {
                    outputSource.append(',');
                }
                if (context.isPrettyPrint()) {
                    outputSource.append('\n');
                    context.appendIndent(outputSource, context.getDepth() + 1);
                }
                StringFormatter.serialize(context, string, outputSource);
                outputSource.append(':');
                if (context.isPrettyPrint()) {
                    outputSource.append(' ');
                }
                context.enter(string, jSONHint);
                string = null;
                object3 = context.preformatInternal(object3);
                context.formatInternal(object3, outputSource);
                context.exit();
                ++n;
            }
        }
        catch (Exception exception) {
            if (string != null) {
                context.enter(string, null);
            }
            throw exception;
        }
        if (context.isPrettyPrint() && n > 0) {
            outputSource.append('\n');
            context.appendIndent(outputSource, context.getDepth());
        }
        outputSource.append('}');
    }
}

