/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.heartbeat;

import java.util.Properties;
import mx4j.connector.RemoteMBeanServer;
import mx4j.connector.rmi.jrmp.JRMPConnector;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.heartbeat.ConnectorException;

public class HeartBeatConnectorFactory {
    private Logger m_logger = Log.getLogger("mx4j.mbean" + this.getClass().getName());
    private static HeartBeatConnectorFactory m_singleton = null;

    public static HeartBeatConnectorFactory getFactory() {
        if (m_singleton == null) {
            m_singleton = new HeartBeatConnectorFactory();
        }
        return m_singleton;
    }

    private HeartBeatConnectorFactory() {
    }

    public RemoteMBeanServer getConnector(Object connType, Object address) throws ConnectorException {
        if (connType.equals("rmi")) {
            JRMPConnector conn;
            Properties env = System.getProperties();
            try {
                this.m_logger.trace(this.getClass().getName() + ".getConnector: connType=" + connType.toString() + " addr=" + address.toString());
                conn = new JRMPConnector();
                conn.connect((String)address, env);
            }
            catch (Exception ex) {
                throw new ConnectorException(ex.getClass().getName());
            }
            return conn.getRemoteMBeanServer();
        }
        throw new ConnectorException("Unknown connector type");
    }
}

