/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.heartbeat;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import mx4j.connector.RemoteMBeanServer;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.heartbeat.ConnectorException;
import mx4j.tools.heartbeat.HeartBeatConnectorFactory;
import mx4j.tools.heartbeat.HeartBeatMBean;

public class HeartBeat
implements HeartBeatMBean {
    private Logger m_logger = Log.getLogger("mx4j.mbean" + this.getClass().getName());
    private HashMap m_listeners = new HashMap();
    private String m_name = "type=heartBeat";
    private int m_period = 10;
    private int m_retries = 3;
    private ObjectName m_objectName;
    private HeartBeatThread m_hbThread = new HeartBeatThread();
    private Thread m_t;
    private boolean[] m_started = new boolean[1];

    public HeartBeat(String name) {
        this.m_name = name;
        try {
            this.m_objectName = new ObjectName(this.m_name);
        }
        catch (Exception ex) {
            // empty catch block
        }
        Properties env = System.getProperties();
        String p = env.getProperty("mx4j.heartbeat.tries");
        if (p != null) {
            this.m_retries = new Integer(p);
        }
        if ((p = env.getProperty("mx4j.heartbeat.period")) != null) {
            this.m_period = new Integer(p);
        }
        this.m_started[0] = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        this.m_t = new Thread((Runnable)this.m_hbThread, this.m_name);
        this.m_t.start();
        boolean[] blArray = this.m_started;
        synchronized (blArray) {
            while (!this.m_started[0]) {
                try {
                    this.m_started.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public void stop() {
        this.m_logger.trace(this.getClass().getName() + ".stop");
        this.m_hbThread.stop();
        this.m_t.interrupt();
        Thread.currentThread();
        Thread.yield();
    }

    public void addHeartBeatListener(String listenerName, Object connectorType, Object listenerAddress) {
        this.m_logger.debug("HeartBeat.addHeartBeatListener: connType=" + connectorType.toString());
        try {
            RemoteMBeanServer conn = HeartBeatConnectorFactory.getFactory().getConnector(connectorType, listenerAddress);
            HeartBeatSession session = new HeartBeatSession(conn);
            HashMap hashMap = this.m_listeners;
            synchronized (hashMap) {
                this.m_listeners.put(listenerName, session);
            }
        }
        catch (ConnectorException ex) {
            this.m_logger.debug("HeartBeat.addHeartBeatListener: " + ex.getMessage());
        }
    }

    public void removeHeartBeatListener(String heartBeatListenerName) {
        HashMap hashMap = this.m_listeners;
        synchronized (hashMap) {
            this.m_listeners.remove(heartBeatListenerName);
        }
    }

    public int getPeriod() {
        return this.m_period;
    }

    public void setPeriod(int period) {
        this.m_period = period;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int nretries) {
        this.m_retries = nretries;
    }

    private class HeartBeatSession {
        private RemoteMBeanServer m_conn;
        private int m_failCount = 0;

        public HeartBeatSession(RemoteMBeanServer conn) {
            this.m_conn = conn;
        }

        public void reset() {
            this.m_failCount = 0;
        }

        public boolean shouldContinue() {
            ++this.m_failCount;
            return this.m_failCount <= HeartBeat.this.m_retries;
        }

        public RemoteMBeanServer getConnection() {
            return this.m_conn;
        }
    }

    private class HeartBeatThread
    implements Runnable {
        private boolean m_stop = false;

        private HeartBeatThread() {
        }

        public void run() {
            boolean[] blArray = HeartBeat.this.m_started;
            synchronized (blArray) {
                ((HeartBeat)HeartBeat.this).m_started[0] = true;
                HeartBeat.this.m_started.notifyAll();
            }
            do {
                HeartBeatSession sess = null;
                String listener = null;
                Object[] params = new Object[1];
                String[] signature = new String[1];
                params[0] = HeartBeat.this.m_objectName.getCanonicalName();
                signature[0] = "java.lang.String";
                try {
                    HashMap listeners;
                    HashMap hashMap = HeartBeat.this.m_listeners;
                    synchronized (hashMap) {
                        listeners = (HashMap)HeartBeat.this.m_listeners.clone();
                    }
                    Set keys = listeners.keySet();
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        listener = (String)it.next();
                        sess = (HeartBeatSession)listeners.get(listener);
                        RemoteMBeanServer conn = sess.getConnection();
                        HeartBeat.this.m_logger.debug("HeartBeatThread.run: calling " + listener);
                        try {
                            conn.invoke(new ObjectName(listener), "processHeartBeat", params, signature);
                            sess.reset();
                        }
                        catch (mx4j.connector.ConnectorException ex) {
                            HeartBeat.this.m_logger.debug("HeartBeatThread.run: ConnectorException listnr=" + listener.toString());
                            if (sess.shouldContinue()) continue;
                            HashMap hashMap2 = HeartBeat.this.m_listeners;
                            synchronized (hashMap2) {
                                HeartBeat.this.m_listeners.remove(listener);
                                HeartBeat.this.m_logger.debug("HeartBeatThread.run: removed listenr=" + listener.toString());
                            }
                            listeners.remove(listener);
                        }
                    }
                }
                catch (Exception ex) {
                    HeartBeat.this.m_logger.debug("HeartBeatThread.run: ex=" + ex.toString());
                }
                try {
                    Thread.sleep(1000 * HeartBeat.this.m_period);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            } while (!this.m_stop);
        }

        public void stop() {
            this.m_stop = true;
        }
    }
}

