/*
 * Decompiled with CFR 0.152.
 */
package mx4j.connector.rmi;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.adaptor.interceptor.InvocationContext;
import mx4j.adaptor.interceptor.InvocationResult;
import mx4j.adaptor.rmi.RMIProtocolAdaptor;
import mx4j.connector.ConnectorException;
import mx4j.connector.JMXConnector;
import mx4j.connector.RemoteMBeanServer;
import mx4j.connector.rmi.RemoteNotificationFilterSupport;
import mx4j.connector.rmi.RemoteNotificationListenerSupport;

public abstract class RMIConnector
implements JMXConnector {
    private RMIProtocolAdaptor m_adaptor;
    private RemoteMBeanServer m_server;
    private InvocationContext m_context;

    public void connect(String jndiName, Hashtable properties) throws Exception {
        if (jndiName == null) {
            throw new NamingException("Null JNDI name");
        }
        InitialContext ctx = new InitialContext(properties);
        Object object = ctx.lookup(jndiName);
        this.m_adaptor = this.narrow(object);
        this.m_server = new RemoteMBeanServerImpl();
    }

    public RemoteMBeanServer getRemoteMBeanServer() {
        if (this.m_server == null) {
            throw new IllegalStateException("connect() has not been called");
        }
        return this.m_server;
    }

    protected abstract RMIProtocolAdaptor narrow(Object var1);

    public void setInvocationContext(InvocationContext context) {
        this.m_context = context;
    }

    public String getRemoteHostName() {
        try {
            return (String)this.invoke("getHostName", new String[0], new Object[0]);
        }
        catch (ConnectorException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    public String getRemoteHostAddress() {
        try {
            return (String)this.invoke("getHostAddress", new String[0], new Object[0]);
        }
        catch (ConnectorException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    protected abstract NotificationListener createRemoteNotificationListener(NotificationListener var1) throws RemoteException;

    protected abstract NotificationFilter createRemoteNotificationFilter(NotificationFilter var1) throws RemoteException;

    protected Object invoke(String methodName, String[] signature, Object[] arguments) throws Exception {
        Invocation invocation = new Invocation();
        invocation.setMethodName(methodName);
        invocation.setSignature(signature);
        invocation.setArguments(arguments);
        invocation.setInvocationContext(this.m_context);
        try {
            InvocationResult result = this.m_adaptor.invoke(invocation);
            return result.getResult();
        }
        catch (RemoteException x) {
            throw new ConnectorException(x);
        }
    }

    public abstract void close();

    private class RemoteMBeanServerImpl
    implements RemoteMBeanServer {
        private RemoteMBeanServer m_proxy;
        private HashMap m_listeners = new HashMap();
        private HashMap m_filters = new HashMap();
        private HashMap m_handbacks = new HashMap();
        static /* synthetic */ Class class$mx4j$connector$RemoteMBeanServer;

        private RemoteMBeanServerImpl() {
            this.m_proxy = (RemoteMBeanServer)Proxy.newProxyInstance((class$mx4j$connector$RemoteMBeanServer == null ? (class$mx4j$connector$RemoteMBeanServer = RemoteMBeanServerImpl.class$("mx4j.connector.RemoteMBeanServer")) : class$mx4j$connector$RemoteMBeanServer).getClassLoader(), new Class[]{class$mx4j$connector$RemoteMBeanServer == null ? (class$mx4j$connector$RemoteMBeanServer = RemoteMBeanServerImpl.class$("mx4j.connector.RemoteMBeanServer")) : class$mx4j$connector$RemoteMBeanServer}, (InvocationHandler)new Handler());
        }

        public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            if (listener == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
            }
            NotificationListener l = null;
            NotificationFilter f = null;
            Object h = null;
            RemoteMBeanServerImpl remoteMBeanServerImpl = this;
            synchronized (remoteMBeanServerImpl) {
                l = this.findListener(listener);
                f = this.findFilter(filter);
                h = this.findHandback(handback);
            }
            this.m_proxy.addNotificationListener(observed, l, f, h);
            RemoteMBeanServerImpl remoteMBeanServerImpl2 = this;
            synchronized (remoteMBeanServerImpl2) {
                this.m_listeners.put(listener, l);
                if (filter != null) {
                    this.m_filters.put(filter, f);
                }
                if (handback != null) {
                    this.m_handbacks.put(handback, h);
                }
            }
        }

        public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            if (listener == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
            }
            NotificationListener l = null;
            NotificationFilter f = null;
            Object h = null;
            RemoteMBeanServerImpl remoteMBeanServerImpl = this;
            synchronized (remoteMBeanServerImpl) {
                l = (NotificationListener)this.m_listeners.get(listener);
                f = (NotificationFilter)this.m_filters.get(filter);
                h = this.m_handbacks.get(handback);
            }
            this.m_proxy.removeNotificationListener(observed, l, f, h);
            RemoteMBeanServerImpl remoteMBeanServerImpl2 = this;
            synchronized (remoteMBeanServerImpl2) {
                this.m_listeners.remove(listener);
                if (filter != null) {
                    this.m_filters.remove(filter);
                }
                if (handback != null) {
                    this.m_handbacks.remove(handback);
                }
            }
        }

        public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
            return this.m_proxy.createMBean(className, objectName);
        }

        public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            return this.m_proxy.createMBean(className, objectName, loaderName);
        }

        public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
            return this.m_proxy.createMBean(className, objectName, args, parameters);
        }

        public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            return this.m_proxy.createMBean(className, objectName, loaderName, args, parameters);
        }

        public ObjectInstance registerMBean(Object mbean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
            return this.m_proxy.registerMBean(mbean, objectName);
        }

        public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
            this.m_proxy.unregisterMBean(objectName);
        }

        public Object getAttribute(ObjectName objectName, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
            return this.m_proxy.getAttribute(objectName, attribute);
        }

        public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            this.m_proxy.setAttribute(objectName, attribute);
        }

        public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException {
            return this.m_proxy.getAttributes(objectName, attributes);
        }

        public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
            return this.m_proxy.setAttributes(objectName, attributes);
        }

        public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException {
            return this.m_proxy.invoke(objectName, methodName, args, parameters);
        }

        public String getDefaultDomain() {
            return this.m_proxy.getDefaultDomain();
        }

        public Integer getMBeanCount() {
            return this.m_proxy.getMBeanCount();
        }

        public boolean isRegistered(ObjectName objectname) {
            return this.m_proxy.isRegistered(objectname);
        }

        public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
            return this.m_proxy.getMBeanInfo(objectName);
        }

        public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
            return this.m_proxy.getObjectInstance(objectName);
        }

        public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException {
            return this.m_proxy.isInstanceOf(objectName, className);
        }

        public Set queryMBeans(ObjectName patternName, QueryExp filter) {
            return this.m_proxy.queryMBeans(patternName, filter);
        }

        public Set queryNames(ObjectName patternName, QueryExp filter) {
            return this.m_proxy.queryNames(patternName, filter);
        }

        private NotificationListener findListener(NotificationListener listener) {
            NotificationListener l = (NotificationListener)this.m_listeners.get(listener);
            if (l != null) {
                return l;
            }
            if (listener instanceof RemoteNotificationListenerSupport) {
                return listener;
            }
            try {
                return RMIConnector.this.createRemoteNotificationListener(listener);
            }
            catch (RemoteException x) {
                throw new ConnectorException(x);
            }
        }

        private NotificationFilter findFilter(NotificationFilter filter) {
            if (filter == null) {
                return null;
            }
            NotificationFilter f = (NotificationFilter)this.m_filters.get(filter);
            if (f != null) {
                return f;
            }
            if (filter instanceof RemoteNotificationFilterSupport) {
                return filter;
            }
            try {
                return RMIConnector.this.createRemoteNotificationFilter(filter);
            }
            catch (RemoteException x) {
                throw new ConnectorException(x);
            }
        }

        private Object findHandback(Object handback) {
            if (handback == null) {
                return null;
            }
            Object h = this.m_handbacks.get(handback);
            if (h != null) {
                return h;
            }
            try {
                return new MarshalledObject<Object>(handback);
            }
            catch (IOException x) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Handback is not serializable"));
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class Handler
        implements InvocationHandler {
            private Handler() {
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args == null) {
                    args = new Object[]{};
                }
                int length = method.getParameterTypes().length;
                String[] signature = new String[length];
                int i = 0;
                while (i < length) {
                    signature[i] = method.getParameterTypes()[i].getName();
                    ++i;
                }
                return RMIConnector.this.invoke(method.getName(), signature, args);
            }
        }
    }
}

