/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mx4j.adaptor.AdaptorServerSocketFactory;
import mx4j.adaptor.PlainAdaptorServerSocketFactory;
import mx4j.adaptor.http.Base64;
import mx4j.adaptor.http.ConstructorsCommandProcessor;
import mx4j.adaptor.http.CreateMBeanCommandProcessor;
import mx4j.adaptor.http.DefaultProcessor;
import mx4j.adaptor.http.DeleteMBeanCommandProcessor;
import mx4j.adaptor.http.HttpAdaptorMBean;
import mx4j.adaptor.http.HttpCommandProcessor;
import mx4j.adaptor.http.HttpException;
import mx4j.adaptor.http.HttpInputStream;
import mx4j.adaptor.http.HttpOutputStream;
import mx4j.adaptor.http.InvokeOperationCommandProcessor;
import mx4j.adaptor.http.MBeanCommandProcessor;
import mx4j.adaptor.http.ProcessorMBean;
import mx4j.adaptor.http.RelationCommandProcessor;
import mx4j.adaptor.http.ServerByDomainCommandProcessor;
import mx4j.adaptor.http.ServerCommandProcessor;
import mx4j.adaptor.http.SetAttributeCommandProcessor;
import mx4j.log.Log;
import mx4j.log.Logger;
import org.w3c.dom.Document;

public class HttpAdaptor
implements HttpAdaptorMBean,
MBeanRegistration {
    private int port = 8080;
    private String host = "localhost";
    private MBeanServer server;
    private ServerSocket serverSocket;
    private boolean alive;
    private Logger log;
    private Map commands = new HashMap();
    private ProcessorMBean processor = null;
    private ObjectName processorName = null;
    private ProcessorMBean defaultProcessor = new DefaultProcessor();
    private String authenticationMethod = "none";
    private String realm = "MX4J";
    private Map authorizations = new HashMap();
    private AdaptorServerSocketFactory socketFactory = null;
    private String factoryName;

    public void setPort(int port) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change port with the server running");
        }
        this.port = port;
    }

    public void setHost(String host) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change port with the server running");
        }
        this.host = host;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String method) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change authentication method with the server running");
        }
        if (method == null || !method.equals("none") && !method.equals("basic") && !method.equals("digest")) {
            throw new IllegalArgumentException("Only accept methods none/basic/digest");
        }
        this.authenticationMethod = method;
    }

    public void setProcessor(ProcessorMBean processor) {
        this.processor = processor;
        this.processorName = null;
    }

    public void setSocketFactory(AdaptorServerSocketFactory factory) {
        this.factoryName = null;
        this.socketFactory = factory;
    }

    public void setSocketFactoryName(String factoryName) {
        this.socketFactory = null;
        this.factoryName = factoryName;
    }

    public void setProcessorName(ObjectName processorName) {
        this.processor = null;
        this.processorName = processorName;
    }

    public ProcessorMBean getProcessor() {
        return this.processor;
    }

    public ObjectName getProcessorName() {
        return this.processorName;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isActive() {
        return this.alive;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.log = Log.getLogger(name.toString());
        this.buildCommands();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    private ServerSocket createServerSocket() throws IOException {
        if (this.socketFactory == null) {
            if (this.factoryName == null) {
                this.socketFactory = new PlainAdaptorServerSocketFactory();
                return this.socketFactory.createServerSocket(this.port, 50, this.host);
            }
            try {
                return (ServerSocket)this.server.invoke(new ObjectName(this.factoryName), "createServerSocket", new Object[]{new Integer(this.port), new Integer(50), this.host}, new String[]{"int", "int", "java.lang.String"});
            }
            catch (Exception x) {
                this.log.error("Exception invoking AdaptorServerSocketFactory via MBeanServer", x);
            }
        } else {
            return this.socketFactory.createServerSocket(this.port, 50, this.host);
        }
        return null;
    }

    public void start() throws IOException {
        if (this.server != null) {
            this.serverSocket = this.createServerSocket();
            if (this.serverSocket == null) {
                this.log.error("Server socket is null");
                return;
            }
            this.log.info("HttpAdaptor server listening on port " + this.port);
            this.alive = true;
            Thread serverThread = new Thread(new Runnable(){

                public void run() {
                    HttpAdaptor.this.log.info("HttpAdaptor starting");
                    while (HttpAdaptor.this.alive) {
                        try {
                            Socket client = null;
                            client = HttpAdaptor.this.serverSocket.accept();
                            if (!HttpAdaptor.this.alive) break;
                            new HttpClient(client).start();
                        }
                        catch (InterruptedIOException e) {
                        }
                        catch (IOException e) {
                        }
                        catch (Exception e) {
                            HttpAdaptor.this.log.warn("Exception during request processing", e);
                        }
                        catch (Error e) {
                            HttpAdaptor.this.log.error("Error during request processing", e);
                        }
                    }
                    try {
                        HttpAdaptor.this.serverSocket.close();
                    }
                    catch (IOException e) {
                        HttpAdaptor.this.log.warn("Exception closing the server", e);
                    }
                    HttpAdaptor.this.serverSocket = null;
                    HttpAdaptor.this.alive = false;
                    HttpAdaptor.this.log.info("Server stopped");
                }
            });
            serverThread.start();
        } else {
            this.log.info("Start failed, no server target server has been set");
        }
    }

    public void restart() throws IOException {
        this.stop();
        this.start();
    }

    public void stop() {
        try {
            if (this.alive) {
                this.alive = false;
                new Socket(this.host, this.port);
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAuthorization(String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException("username and passwords cannot be null");
        }
        this.authorizations.put(username, password);
    }

    private boolean isUsernameValid(String username, String password) {
        if (this.authorizations.containsKey(username)) {
            return password.equals(this.authorizations.get(username));
        }
        return false;
    }

    protected HttpCommandProcessor getProcessor(String path) {
        return (HttpCommandProcessor)this.commands.get(path);
    }

    protected void buildCommands() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.commands.put("server", new ServerCommandProcessor(this.server, builder));
            this.commands.put("serverbydomain", new ServerByDomainCommandProcessor(this.server, builder));
            this.commands.put("mbean", new MBeanCommandProcessor(this.server, builder));
            this.commands.put("setattribute", new SetAttributeCommandProcessor(this.server, builder));
            this.commands.put("delete", new DeleteMBeanCommandProcessor(this.server, builder));
            this.commands.put("invoke", new InvokeOperationCommandProcessor(this.server, builder));
            this.commands.put("create", new CreateMBeanCommandProcessor(this.server, builder));
            this.commands.put("relation", new RelationCommandProcessor(this.server, builder));
            this.commands.put("constructors", new ConstructorsCommandProcessor(this.server, builder));
        }
        catch (ParserConfigurationException e) {
            this.log.error("Exception building the Document Factories", e);
        }
    }

    protected void postProcess(HttpOutputStream out, HttpInputStream in, Document document) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null && this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.adaptor.http.ProcessorMBean")) {
            this.server.invoke(this.processorName, "writeResponse", new Object[]{out, in, document}, new String[]{"mx4j.adaptor.http.HttpOutputStream", "mx4j.adaptor.http.HttpInputStream", "org.w3c.dom.Document"});
            processed = true;
        }
        if (!processed && this.processor != null) {
            this.processor.writeResponse(out, in, document);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.writeResponse(out, in, document);
        }
    }

    protected void findUnknownElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null && this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.adaptor.http.ProcessorMBean")) {
            this.server.invoke(this.processorName, "notFoundElement", new Object[]{path, out, in}, new String[]{"java.lang.String", "mx4j.adaptor.http.HttpOutputStream", "mx4j.adaptor.http.HttpInputStream"});
            processed = true;
        }
        if (!processed && this.processor != null) {
            this.processor.notFoundElement(path, out, in);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.notFoundElement(path, out, in);
        }
    }

    protected String preProcess(String path) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            this.log.trace("Preprocess using " + this.processorName);
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.adaptor.http.ProcessorMBean")) {
                this.log.trace("Preprocessing");
                path = (String)this.server.invoke(this.processorName, "preProcess", new Object[]{path}, new String[]{"java.lang.String"});
                processed = true;
            }
            this.log.trace(this.processorName + " not found");
        }
        if (!processed && this.processor != null) {
            path = this.processor.preProcess(path);
            processed = true;
        }
        if (!processed) {
            path = this.defaultProcessor.preProcess(path);
        }
        return path;
    }

    protected void postProcess(HttpOutputStream out, HttpInputStream in, Exception e) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null && this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.adaptor.http.ProcessorMBean")) {
            this.server.invoke(this.processorName, "writeError", new Object[]{out, in, e}, new String[]{"mx4j.adaptor.http.HttpOutputStream", "mx4j.adaptor.http.HttpInputStream", "java.lang.Exception"});
            processed = true;
        }
        if (!processed && this.processor != null) {
            this.processor.writeError(out, in, e);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.writeError(out, in, e);
        }
    }

    private class HttpClient
    extends Thread {
        private Socket client;

        HttpClient(Socket client) {
            this.client = client;
        }

        public boolean isValid(String authorizationString) {
            String decodeString;
            if (HttpAdaptor.this.authenticationMethod.startsWith("basic") && (decodeString = Base64.decodeToString(authorizationString = authorizationString.substring(5, authorizationString.length()))).indexOf(":") > 0) {
                try {
                    StringTokenizer tokens = new StringTokenizer(decodeString, ":");
                    String username = tokens.nextToken();
                    String password = tokens.nextToken();
                    return HttpAdaptor.this.isUsernameValid(username, password);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }

        private boolean handleAuthentication(HttpInputStream in, HttpOutputStream out) throws IOException {
            if (HttpAdaptor.this.authenticationMethod.equals("basic")) {
                Iterator h = in.getHeaders().keySet().iterator();
                String result = in.getHeader("authorization");
                if (result != null) {
                    if (this.isValid(result)) {
                        return true;
                    }
                    throw new HttpException(403, "Authentication failed");
                }
                out.setCode(401);
                out.setHeader("WWW-Authenticate", "Basic realm=\"" + HttpAdaptor.this.realm + "\"");
                out.sendHeaders();
                out.flush();
                return false;
            }
            if (HttpAdaptor.this.authenticationMethod.equals("digest")) {
                // empty if block
            }
            return true;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block26: {
                block25: {
                    httpIn = null;
                    httpOut = null;
                    try {
                        try {
                            in = this.client.getInputStream();
                            httpIn = new HttpInputStream(in);
                            httpIn.readRequest();
                            path = httpIn.getPath();
                            queryString = httpIn.getQueryString();
                            HttpAdaptor.access$000(HttpAdaptor.this).info("Request " + path + (queryString == null ? "" : "?" + queryString));
                            postPath = HttpAdaptor.this.preProcess(path);
                            if (!postPath.equals(path)) {
                                HttpAdaptor.access$000(HttpAdaptor.this).info("Processor replaced path " + path + " with the path " + postPath);
                                path = postPath;
                            }
                            if (!this.handleAuthentication(httpIn, (HttpOutputStream)(httpOut = new HttpOutputStream(out = this.client.getOutputStream(), httpIn)))) {
                                var11_12 = null;
                                break block25;
                            }
                            processor = HttpAdaptor.this.getProcessor(path.substring(1, path.length()));
                            if (processor == null) {
                                HttpAdaptor.access$000(HttpAdaptor.this).info("No suitable command processor found, requesting from processor path " + path);
                                HttpAdaptor.this.findUnknownElement(path, (HttpOutputStream)httpOut, httpIn);
                                break block26;
                            } else {
                                document = processor.executeRequest(httpIn);
                                HttpAdaptor.this.postProcess((HttpOutputStream)httpOut, httpIn, document);
                            }
                            break block26;
                        }
                        catch (Exception ex) {
                            HttpAdaptor.access$000(HttpAdaptor.this).warn("Exception during http request", ex);
                            if (httpOut != null) {
                                try {
                                    HttpAdaptor.this.postProcess((HttpOutputStream)httpOut, httpIn, ex);
                                }
                                catch (IOException e) {
                                    HttpAdaptor.access$000(HttpAdaptor.this).warn("IOException during http request", e);
                                }
                                catch (JMException e) {
                                    HttpAdaptor.access$000(HttpAdaptor.this).warn("JMException during http request", e);
                                }
                            }
                            var11_14 = null;
                            try {
                                if (httpOut != null) {
                                    httpOut.flush();
                                }
                                this.client.close();
                                return;
                            }
                            catch (IOException ignored) {
                                return;
                            }
                        }
                        catch (Error ex) {
                            HttpAdaptor.access$000(HttpAdaptor.this).error("Error during http request ", ex);
                            var11_15 = null;
                            try {}
                            catch (IOException ignored) {
                                return;
                            }
                            if (httpOut != null) {
                                httpOut.flush();
                            }
                            this.client.close();
                            return;
                        }
                    }
                    catch (Throwable var10_24) {
                        var11_16 = null;
                        ** try [egrp 3[TRYBLOCK] [5 : 398->416)] { 
lbl63:
                        // 1 sources

                        if (httpOut != null) {
                            httpOut.flush();
                        }
                        this.client.close();
                        throw var10_24;
lbl67:
                        // 1 sources

                        catch (IOException ignored) {
                            // empty catch block
                        }
                        throw var10_24;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [5 : 398->416)] { 
lbl72:
                // 1 sources

                if (httpOut != null) {
                    httpOut.flush();
                }
                this.client.close();
                return;
lbl76:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
                return;
            }
            var11_13 = null;
            try {}
            catch (IOException ignored) {}
            if (httpOut != null) {
                httpOut.flush();
            }
            this.client.close();
            return;
        }
    }
}

