/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.loading.DefaultLoaderRepository;
import javax.xml.parsers.DocumentBuilder;
import mx4j.adaptor.http.HttpCommandProcessor;
import mx4j.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ConstructorsCommandProcessor
implements HttpCommandProcessor {
    private MBeanServer server;
    private DocumentBuilder builder;

    public ConstructorsCommandProcessor(MBeanServer server, DocumentBuilder builder) {
        this.server = server;
        this.builder = builder;
    }

    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        String classname = in.getVariable("classname");
        if (classname == null || classname.trim().length() == 0) {
            return this.createException(document, "classname parameter required");
        }
        Class<?> targetClass = null;
        try {
            targetClass = DefaultLoaderRepository.loadClass(classname);
            if (targetClass == null) {
                targetClass = ClassLoader.getSystemClassLoader().loadClass(classname);
            }
            if (targetClass == null) {
                targetClass = this.getClass().getClassLoader().loadClass(classname);
            }
        }
        catch (ClassNotFoundException e) {
            return this.createException(document, "class " + classname + " not found");
        }
        Element root = document.createElement("Class");
        root.setAttribute("classname", classname);
        document.appendChild(root);
        Constructor<?>[] constructors = targetClass.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            Element constructor = document.createElement("Constructor");
            constructor.setAttribute("name", constructors[i].getName());
            this.addParameters(constructor, document, constructors[i].getParameterTypes());
            root.appendChild(constructor);
            ++i;
        }
        return document;
    }

    protected void addParameters(Element node, Document document, Class[] parameters) {
        int j = 0;
        while (j < parameters.length) {
            Element parameter = document.createElement("Parameter");
            parameter.setAttribute("type", parameters[j].getName());
            parameter.setAttribute("id", "" + j);
            node.appendChild(parameter);
            ++j;
        }
    }

    private Document createException(Document document, String message) {
        Element exceptionElement = document.createElement("Exception");
        document.appendChild(exceptionElement);
        exceptionElement.setAttribute("errorMsg", message);
        return document;
    }
}

