/*
 * Decompiled with CFR 0.152.
 */
package mx.wire4.auth;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import mx.wire4.ApiException;
import mx.wire4.Configuration;
import mx.wire4.core.CachedToken;
import mx.wire4.core.EnvironmentEnum;
import org.apache.commons.lang3.StringUtils;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.httpurlconnection.HttpUrlConnectionExecutor;
import org.dmfs.oauth2.client.BasicOAuth2AuthorizationProvider;
import org.dmfs.oauth2.client.BasicOAuth2Client;
import org.dmfs.oauth2.client.BasicOAuth2ClientCredentials;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2AuthorizationProvider;
import org.dmfs.oauth2.client.OAuth2Client;
import org.dmfs.oauth2.client.OAuth2ClientCredentials;
import org.dmfs.oauth2.client.OAuth2Grant;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.grants.ClientCredentialsGrant;
import org.dmfs.oauth2.client.grants.ResourceOwnerPasswordGrant;
import org.dmfs.oauth2.client.grants.TokenRefreshGrant;
import org.dmfs.oauth2.client.scope.BasicScope;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.uris.LazyUri;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.Duration;

public class OAuthWire4 {
    private static final int MAX_APP_USER_SIZE_CACHED = 100;
    private final Map<String, CachedToken> tokensCachedAppUser;
    private String clientId;
    private String clientSecret;
    private String tokenUrl;

    public OAuthWire4(String clientId, String clientSecret, EnvironmentEnum environment) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        if (environment == null) {
            throw new IllegalArgumentException("Environment enum value is required...");
        }
        this.tokenUrl = environment.getTokenUrl();
        Configuration.getDefaultApiClient().setBasePath(environment.getServiceUrl());
        this.tokensCachedAppUser = this.createTokenCachedAppUser();
    }

    private Map<String, CachedToken> createTokenCachedAppUser() {
        return Collections.synchronizedMap(new LinkedHashMap<String, CachedToken>(){
            private static final long serialVersionUID = -6109304202490886343L;

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 100;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String obtainAccessTokenApp(String scope) throws ApiException {
        Map<String, CachedToken> map = this.tokensCachedAppUser;
        synchronized (map) {
            String accessToken;
            try {
                this.validateScopeIsPresent(scope);
                CachedToken tokenCachedApp = this.tokensCachedAppUser.get(this.clientId + scope);
                if (tokenCachedApp == null) {
                    tokenCachedApp = new CachedToken(null, null, null);
                    this.tokensCachedAppUser.put(this.clientId + scope, tokenCachedApp);
                }
                if (tokenCachedApp.getToken() != null && this.isValid(tokenCachedApp.getToken().expirationDate())) {
                    return this.formatToHeader(tokenCachedApp.getToken().accessToken().toString());
                }
                HttpUrlConnectionExecutor executor = new HttpUrlConnectionExecutor();
                ClientCredentialsGrant clientCredentialsGrant = new ClientCredentialsGrant(this.buildOAuthClient(), (OAuth2Scope)new BasicScope(new String[]{scope}));
                OAuth2AccessToken token = clientCredentialsGrant.accessToken((HttpRequestExecutor)executor);
                tokenCachedApp.setToken(token);
                accessToken = token.accessToken().toString();
            }
            catch (IOException | ProtocolError | ProtocolException e) {
                throw new ApiException(e);
            }
            return this.formatToHeader(accessToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String obtainAccessTokenAppUser(String userKey, String secretKey, String scope) throws ApiException {
        Map<String, CachedToken> map = this.tokensCachedAppUser;
        synchronized (map) {
            String accessToken;
            try {
                boolean useRefreshToken;
                TokenRefreshGrant grant;
                this.validObtainAccessTokenAppUser(userKey, secretKey, scope);
                CachedToken cachedToken = this.tokensCachedAppUser.get(userKey + scope);
                if (cachedToken != null) {
                    if (this.isValid(cachedToken.getToken().expirationDate())) {
                        return this.formatToHeader(cachedToken.getToken().accessToken().toString());
                    }
                    grant = new TokenRefreshGrant(this.buildOAuthClient(), cachedToken.getToken());
                    useRefreshToken = true;
                } else {
                    grant = new ResourceOwnerPasswordGrant(this.buildOAuthClient(), (OAuth2Scope)new BasicScope(new String[]{scope}), (CharSequence)userKey, (CharSequence)secretKey);
                    useRefreshToken = false;
                }
                OAuth2AccessToken token = this.executeTokenRequest(userKey, secretKey, scope, (OAuth2Grant)grant, useRefreshToken);
                this.tokensCachedAppUser.put(userKey + scope, new CachedToken(userKey, secretKey, token));
                accessToken = token.accessToken().toString();
            }
            catch (ProtocolException e) {
                throw new ApiException((Throwable)e);
            }
            return this.formatToHeader(accessToken);
        }
    }

    private OAuth2AccessToken executeTokenRequest(String userKey, String secretKey, String scope, OAuth2Grant grant, boolean useRefreshToken) throws ApiException {
        try {
            HttpUrlConnectionExecutor executor = new HttpUrlConnectionExecutor();
            return grant.accessToken((HttpRequestExecutor)executor);
        }
        catch (IOException | ProtocolError | ProtocolException e) {
            e.printStackTrace();
            if (useRefreshToken) {
                ResourceOwnerPasswordGrant grantRetry = new ResourceOwnerPasswordGrant(this.buildOAuthClient(), (OAuth2Scope)new BasicScope(new String[]{scope}), (CharSequence)userKey, (CharSequence)secretKey);
                return this.executeTokenRequest(userKey, secretKey, scope, (OAuth2Grant)grantRetry, false);
            }
            throw new ApiException(e);
        }
    }

    private void validateScopeIsPresent(String scope) throws ApiException {
        if (StringUtils.isBlank((CharSequence)scope)) {
            throw new ApiException(HttpStatus.UNAUTHORIZED.statusCode(), "A least one scope is required...");
        }
    }

    private String formatToHeader(String token) {
        return "Bearer " + token;
    }

    private boolean isValid(DateTime expirationDate) {
        DateTime now = DateTime.now().addDuration(new Duration(1, 0, 0, 5, 0));
        return expirationDate != null && now.before(expirationDate);
    }

    private void validObtainAccessTokenAppUser(String userKey, String secretKey, String scope) throws ApiException {
        if (StringUtils.isBlank((CharSequence)userKey)) {
            throw new ApiException(HttpStatus.UNAUTHORIZED.statusCode(), "User key is required...");
        }
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            throw new ApiException(HttpStatus.UNAUTHORIZED.statusCode(), "Secret key is required...");
        }
        this.validateScopeIsPresent(scope);
    }

    private OAuth2Client buildOAuthClient() {
        BasicOAuth2AuthorizationProvider provider = new BasicOAuth2AuthorizationProvider(URI.create(this.tokenUrl), URI.create(this.tokenUrl), new Duration(1, 0, 3600));
        BasicOAuth2ClientCredentials credentials = new BasicOAuth2ClientCredentials(this.clientId, this.clientSecret);
        return new BasicOAuth2Client((OAuth2AuthorizationProvider)provider, (OAuth2ClientCredentials)credentials, (Uri)new LazyUri((UriEncoded)new Precoded((CharSequence)"http://localhost")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String regenerateAccessTokenApp(String scope) throws ApiException {
        Map<String, CachedToken> map = this.tokensCachedAppUser;
        synchronized (map) {
            String accessToken;
            try {
                this.validateScopeIsPresent(scope);
                CachedToken tokenCachedApp = this.tokensCachedAppUser.get(this.clientId + scope);
                if (tokenCachedApp == null) {
                    tokenCachedApp = new CachedToken(null, null, null);
                    this.tokensCachedAppUser.put(this.clientId + scope, tokenCachedApp);
                }
                HttpUrlConnectionExecutor executor = new HttpUrlConnectionExecutor();
                ClientCredentialsGrant clientCredentialsGrant = new ClientCredentialsGrant(this.buildOAuthClient(), (OAuth2Scope)new BasicScope(new String[]{scope}));
                OAuth2AccessToken token = clientCredentialsGrant.accessToken((HttpRequestExecutor)executor);
                tokenCachedApp.setToken(token);
                accessToken = token.accessToken().toString();
            }
            catch (IOException | ProtocolError | ProtocolException e) {
                throw new ApiException(e);
            }
            return this.formatToHeader(accessToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String regenerateAccessTokenAppUser(String userKey, String secretKey, String scope) throws ApiException {
        Map<String, CachedToken> map = this.tokensCachedAppUser;
        synchronized (map) {
            String accessToken;
            try {
                this.validObtainAccessTokenAppUser(userKey, secretKey, scope);
                ResourceOwnerPasswordGrant grant = new ResourceOwnerPasswordGrant(this.buildOAuthClient(), (OAuth2Scope)new BasicScope(new String[]{scope}), (CharSequence)userKey, (CharSequence)secretKey);
                boolean useRefreshToken = false;
                OAuth2AccessToken token = this.executeTokenRequest(userKey, secretKey, scope, (OAuth2Grant)grant, false);
                this.tokensCachedAppUser.put(userKey + scope, new CachedToken(userKey, secretKey, token));
                accessToken = token.accessToken().toString();
            }
            catch (ProtocolException e) {
                throw new ApiException((Throwable)e);
            }
            return this.formatToHeader(accessToken);
        }
    }

    public Map<String, CachedToken> getTokensCachedAppUser() {
        return this.tokensCachedAppUser;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }
}

