/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.core.content.res.TypedArrayUtils;
import moe.shizuku.preference.Preference;
import moe.shizuku.preference.PreferenceFragment;
import moe.shizuku.preference.PreferenceManager;
import moe.shizuku.preference.R;

public class RingtonePreference
extends Preference
implements PreferenceManager.OnActivityResultListener {
    private static final String TAG = "RingtonePreference";
    private String mSummary;
    private String mValue;
    private Uri mUri;
    private String mSummaryNone;
    private int mRingtoneType;
    private boolean mShowDefault;
    private boolean mShowSilent;
    private int mRequestCode;

    public RingtonePreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RingtonePreference, defStyleAttr, defStyleRes);
        this.mRingtoneType = TypedArrayUtils.getInt((TypedArray)a, (int)R.styleable.RingtonePreference_ringtoneType, (int)R.styleable.RingtonePreference_android_ringtoneType, (int)1);
        this.mShowDefault = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.RingtonePreference_showDefault, (int)R.styleable.RingtonePreference_android_showDefault, (boolean)true);
        this.mShowSilent = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.RingtonePreference_showSilent, (int)R.styleable.RingtonePreference_android_showSilent, (boolean)true);
        this.mSummaryNone = a.getString(R.styleable.RingtonePreference_summaryNone);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.Preference, defStyleAttr, defStyleRes);
        this.mSummary = TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.Preference_summary, (int)R.styleable.Preference_android_summary);
        a.recycle();
    }

    public RingtonePreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Preference_RingtonePreference);
    }

    public RingtonePreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ringtonePreferenceStyle);
    }

    public RingtonePreference(Context context) {
        this(context, null);
    }

    public int getRingtoneType() {
        return this.mRingtoneType;
    }

    public void setRingtoneType(int type) {
        this.mRingtoneType = type;
    }

    public boolean getShowDefault() {
        return this.mShowDefault;
    }

    public void setShowDefault(boolean showDefault) {
        this.mShowDefault = showDefault;
    }

    public boolean getShowSilent() {
        return this.mShowSilent;
    }

    public void setShowSilent(boolean showSilent) {
        this.mShowSilent = showSilent;
    }

    @Override
    protected void onClick() {
        Intent intent = new Intent("android.intent.action.RINGTONE_PICKER");
        this.onPrepareRingtonePickerIntent(intent);
        PreferenceFragment owningFragment = this.getPreferenceManager().getFragment();
        if (owningFragment != null) {
            owningFragment.startActivityForResult(intent, this.mRequestCode);
        }
    }

    protected void onPrepareRingtonePickerIntent(Intent ringtonePickerIntent) {
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.EXISTING_URI", (Parcelable)this.onRestoreRingtone());
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.SHOW_DEFAULT", this.mShowDefault);
        if (this.mShowDefault) {
            ringtonePickerIntent.putExtra("android.intent.extra.ringtone.DEFAULT_URI", (Parcelable)RingtoneManager.getDefaultUri((int)this.getRingtoneType()));
        }
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.SHOW_SILENT", this.mShowSilent);
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.TYPE", this.mRingtoneType);
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.TITLE", this.getTitle());
    }

    protected void onSaveRingtone(Uri ringtoneUri) {
        this.persistString(ringtoneUri != null ? ringtoneUri.toString() : "");
        this.setValue(ringtoneUri);
    }

    protected Uri onRestoreRingtone() {
        String uriString = this.getPersistedString(null);
        return !TextUtils.isEmpty((CharSequence)uriString) ? Uri.parse((String)uriString) : null;
    }

    @Override
    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    @Override
    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        String uri;
        String string = uri = restorePersistedValue ? this.getPersistedString(null) : (String)defaultValue;
        if (!TextUtils.isEmpty((CharSequence)uri)) {
            this.setValue(Uri.parse((String)uri));
        } else {
            this.setValue(this.mSummaryNone == null ? "" : this.mSummaryNone);
        }
        if (restorePersistedValue) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)((String)defaultValue))) {
            this.onSaveRingtone(Uri.parse((String)((String)defaultValue)));
        }
    }

    @Override
    public CharSequence getSummary() {
        String value = this.mValue;
        if (this.mSummary == null) {
            return super.getSummary();
        }
        return String.format(this.mSummary, value == null ? "" : value);
    }

    @Override
    public void setSummary(CharSequence summary) {
        super.setSummary(summary);
        if (summary == null && this.mSummary != null) {
            this.mSummary = null;
        } else if (summary != null && !summary.equals(this.mSummary)) {
            this.mSummary = summary.toString();
        }
    }

    public void setValue(Uri uri) {
        if (uri != null) {
            Ringtone rng = RingtoneManager.getRingtone((Context)this.getContext(), (Uri)uri);
            if (rng != null) {
                this.setValue(rng.getTitle(this.getContext()));
            }
        } else {
            this.setValue(this.mSummaryNone == null ? "" : this.mSummaryNone);
        }
        this.notifyChanged();
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    @Override
    protected void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        super.onAttachedToHierarchy(preferenceManager);
        preferenceManager.registerOnActivityResultListener(this);
        this.mRequestCode = preferenceManager.getNextRequestCode();
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.mRequestCode) {
            Uri uri;
            if (data != null && ((uri = (Uri)data.getParcelableExtra("android.intent.extra.ringtone.PICKED_URI")) == null || !uri.equals((Object)this.mUri)) && this.callChangeListener(this.mUri != null ? this.mUri.toString() : "")) {
                this.mUri = uri;
                this.onSaveRingtone(this.mUri);
            }
            return true;
        }
        return false;
    }
}

