/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.AbsSavedState;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.core.content.SharedPreferencesCompat;
import androidx.core.content.res.TypedArrayUtils;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import moe.shizuku.preference.PreferenceDataStore;
import moe.shizuku.preference.PreferenceGroup;
import moe.shizuku.preference.PreferenceManager;
import moe.shizuku.preference.PreferenceViewHolder;
import moe.shizuku.preference.R;

public class Preference
implements Comparable<Preference> {
    public static final int DEFAULT_ORDER = Integer.MAX_VALUE;
    private Context mContext;
    @Nullable
    private PreferenceManager mPreferenceManager;
    @Nullable
    private PreferenceDataStore mPreferenceDataStore;
    private long mId;
    private boolean mHasId;
    private OnPreferenceChangeListener mOnChangeListener;
    private OnPreferenceClickListener mOnClickListener;
    private int mOrder = Integer.MAX_VALUE;
    private int mViewId = 0;
    private CharSequence mTitle;
    private CharSequence mSummary;
    private int mIconResId;
    private Drawable mIcon;
    private String mKey;
    private Intent mIntent;
    private String mFragment;
    private Bundle mExtras;
    private boolean mEnabled = true;
    private boolean mSelectable = true;
    private boolean mRequiresKey;
    private boolean mPersistent = true;
    private String mDependencyKey;
    private Object mDefaultValue;
    private boolean mDependencyMet = true;
    private boolean mParentDependencyMet = true;
    private boolean mVisible = true;
    private int mDividerBelowVisibility = 0;
    private boolean mHasSingleLineTitleAttr;
    private boolean mSingleLineTitle = true;
    private boolean mIconSpaceReserved;
    private boolean mShouldDisableView = true;
    private int mLayoutResId = R.layout.preference_material;
    private int mWidgetLayoutResId;
    private OnPreferenceChangeInternalListener mListener;
    private List<Preference> mDependents;
    private PreferenceGroup mParentGroup;
    private boolean mWasDetached;
    private boolean mBaseMethodCalled;
    private final View.OnClickListener mClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            Preference.this.performClick(v);
        }
    };

    @SuppressLint(value={"RestrictedApi"})
    public Preference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Preference, defStyleAttr, defStyleRes);
        this.mIconResId = TypedArrayUtils.getResourceId((TypedArray)a, (int)R.styleable.Preference_icon, (int)R.styleable.Preference_android_icon, (int)0);
        this.mKey = TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.Preference_key, (int)R.styleable.Preference_android_key);
        this.mTitle = TypedArrayUtils.getText((TypedArray)a, (int)R.styleable.Preference_title, (int)R.styleable.Preference_android_title);
        this.mSummary = TypedArrayUtils.getText((TypedArray)a, (int)R.styleable.Preference_summary, (int)R.styleable.Preference_android_summary);
        this.mOrder = TypedArrayUtils.getInt((TypedArray)a, (int)R.styleable.Preference_order, (int)R.styleable.Preference_android_order, (int)Integer.MAX_VALUE);
        this.mFragment = TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.Preference_fragment, (int)R.styleable.Preference_android_fragment);
        this.mLayoutResId = TypedArrayUtils.getResourceId((TypedArray)a, (int)R.styleable.Preference_layout, (int)R.styleable.Preference_android_layout, (int)R.layout.preference_material);
        this.mWidgetLayoutResId = TypedArrayUtils.getResourceId((TypedArray)a, (int)R.styleable.Preference_widgetLayout, (int)R.styleable.Preference_android_widgetLayout, (int)0);
        this.mEnabled = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.Preference_enabled, (int)R.styleable.Preference_android_enabled, (boolean)true);
        this.mSelectable = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.Preference_selectable, (int)R.styleable.Preference_android_selectable, (boolean)true);
        this.mPersistent = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.Preference_persistent, (int)R.styleable.Preference_android_persistent, (boolean)true);
        this.mDependencyKey = TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.Preference_dependency, (int)R.styleable.Preference_android_dependency);
        this.mDividerBelowVisibility = TypedArrayUtils.getInt((TypedArray)a, (int)R.styleable.Preference_dividerBelowVisibility, (int)R.styleable.Preference_dividerBelowVisibility, (int)0);
        if (a.hasValue(R.styleable.Preference_defaultValue)) {
            this.mDefaultValue = this.onGetDefaultValue(a, R.styleable.Preference_defaultValue);
        } else if (a.hasValue(R.styleable.Preference_android_defaultValue)) {
            this.mDefaultValue = this.onGetDefaultValue(a, R.styleable.Preference_android_defaultValue);
        }
        this.mShouldDisableView = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.Preference_shouldDisableView, (int)R.styleable.Preference_android_shouldDisableView, (boolean)true);
        this.mHasSingleLineTitleAttr = a.hasValue(R.styleable.Preference_singleLineTitle);
        if (this.mHasSingleLineTitleAttr) {
            this.mSingleLineTitle = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.Preference_singleLineTitle, (int)R.styleable.Preference_android_singleLineTitle, (boolean)true);
        }
        this.mIconSpaceReserved = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.Preference_iconSpaceReserved, (int)R.styleable.Preference_android_iconSpaceReserved, (boolean)false);
        a.recycle();
    }

    public Preference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Preference_Material);
    }

    public Preference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.preferenceStyle);
    }

    public Preference(Context context) {
        this(context, null);
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return null;
    }

    public void setIntent(Intent intent) {
        this.mIntent = intent;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public void setFragment(String fragment) {
        this.mFragment = fragment;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public void setPreferenceDataStore(PreferenceDataStore dataStore) {
        this.mPreferenceDataStore = dataStore;
    }

    @Nullable
    public PreferenceDataStore getPreferenceDataStore() {
        if (this.mPreferenceDataStore != null) {
            return this.mPreferenceDataStore;
        }
        if (this.mPreferenceManager != null) {
            return this.mPreferenceManager.getPreferenceDataStore();
        }
        return null;
    }

    public Bundle getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    public Bundle peekExtras() {
        return this.mExtras;
    }

    public void setLayoutResource(int layoutResId) {
        this.mLayoutResId = layoutResId;
    }

    public final int getLayoutResource() {
        return this.mLayoutResId;
    }

    public void setWidgetLayoutResource(int widgetLayoutResId) {
        this.mWidgetLayoutResId = widgetLayoutResId;
    }

    public final int getWidgetLayoutResource() {
        return this.mWidgetLayoutResId;
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        View imageFrame;
        ImageView imageView;
        TextView summaryView;
        holder.itemView.setOnClickListener(this.mClickListener);
        holder.itemView.setId(this.mViewId);
        TextView titleView = (TextView)holder.findViewById(16908310);
        if (titleView != null) {
            CharSequence title = this.getTitle();
            if (!TextUtils.isEmpty((CharSequence)title)) {
                titleView.setText(title);
                titleView.setVisibility(0);
                if (this.mHasSingleLineTitleAttr) {
                    titleView.setSingleLine(this.mSingleLineTitle);
                }
            } else {
                titleView.setVisibility(8);
            }
        }
        if ((summaryView = (TextView)holder.findViewById(0x1020010)) != null) {
            CharSequence summary = this.getSummary();
            if (!TextUtils.isEmpty((CharSequence)summary)) {
                summaryView.setText(summary);
                summaryView.setVisibility(0);
            } else {
                summaryView.setVisibility(8);
            }
        }
        if ((imageView = (ImageView)holder.findViewById(16908294)) != null) {
            if (this.mIconResId != 0 || this.mIcon != null) {
                if (this.mIcon == null) {
                    this.mIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)this.mIconResId);
                }
                if (this.mIcon != null) {
                    imageView.setImageDrawable(this.mIcon);
                }
            }
            if (this.mIcon != null) {
                imageView.setVisibility(0);
            } else {
                imageView.setVisibility(this.mIconSpaceReserved ? 4 : 8);
            }
        }
        if ((imageFrame = holder.findViewById(R.id.icon_frame)) != null) {
            if (this.mIcon != null) {
                imageFrame.setVisibility(0);
            } else {
                imageFrame.setVisibility(this.mIconSpaceReserved ? 4 : 8);
            }
        }
        if (this.mShouldDisableView) {
            this.setEnabledStateOnViews(holder.itemView, this.isEnabled());
        } else {
            this.setEnabledStateOnViews(holder.itemView, true);
        }
        boolean selectable = this.isSelectable();
        holder.itemView.setFocusable(selectable);
        holder.itemView.setClickable(selectable);
    }

    public void onViewRecycled(PreferenceViewHolder holder) {
    }

    private void setEnabledStateOnViews(View v, boolean enabled) {
        v.setEnabled(enabled);
        if (v instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)v;
            for (int i = vg.getChildCount() - 1; i >= 0; --i) {
                this.setEnabledStateOnViews(vg.getChildAt(i), enabled);
            }
        }
    }

    public void setOrder(int order) {
        if (order != this.mOrder) {
            this.mOrder = order;
            this.notifyHierarchyChanged();
        }
    }

    public int getOrder() {
        return this.mOrder;
    }

    public void setViewId(int viewId) {
        this.mViewId = viewId;
    }

    public void setTitle(CharSequence title) {
        if (title == null && this.mTitle != null || title != null && !title.equals(this.mTitle)) {
            this.mTitle = title;
            this.notifyChanged();
        }
    }

    public void setTitle(int titleResId) {
        this.setTitle(this.mContext.getString(titleResId));
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public void setIcon(Drawable icon) {
        if (icon == null && this.mIcon != null || icon != null && this.mIcon != icon) {
            this.mIcon = icon;
            this.mIconResId = 0;
            this.notifyChanged();
        }
    }

    public void setIcon(int iconResId) {
        this.setIcon(ContextCompat.getDrawable((Context)this.mContext, (int)iconResId));
        this.mIconResId = iconResId;
    }

    public Drawable getIcon() {
        if (this.mIcon == null && this.mIconResId != 0) {
            this.mIcon = ContextCompat.getDrawable((Context)this.mContext, (int)this.mIconResId);
        }
        return this.mIcon;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public void setSummary(CharSequence summary) {
        if (summary == null && this.mSummary != null || summary != null && !summary.equals(this.mSummary)) {
            this.mSummary = summary;
            this.notifyChanged();
        }
    }

    public void setSummary(int summaryResId) {
        this.setSummary(this.mContext.getString(summaryResId));
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    public boolean isEnabled() {
        return this.mEnabled && this.mDependencyMet && this.mParentDependencyMet;
    }

    public void setSelectable(boolean selectable) {
        if (this.mSelectable != selectable) {
            this.mSelectable = selectable;
            this.notifyChanged();
        }
    }

    public boolean isSelectable() {
        return this.mSelectable;
    }

    public void setShouldDisableView(boolean shouldDisableView) {
        this.mShouldDisableView = shouldDisableView;
        this.notifyChanged();
    }

    public boolean getShouldDisableView() {
        return this.mShouldDisableView;
    }

    public final void setVisible(boolean visible) {
        if (this.mVisible != visible) {
            this.mVisible = visible;
            if (this.mListener != null) {
                this.mListener.onPreferenceVisibilityChange(this);
            }
        }
    }

    public final boolean isVisible() {
        return this.mVisible;
    }

    long getId() {
        return this.mId;
    }

    protected void onClick() {
    }

    public void setKey(String key) {
        this.mKey = key;
        if (this.mRequiresKey && !this.hasKey()) {
            this.requireKey();
        }
    }

    public String getKey() {
        return this.mKey;
    }

    void requireKey() {
        if (TextUtils.isEmpty((CharSequence)this.mKey)) {
            throw new IllegalStateException("Preference does not have a key assigned.");
        }
        this.mRequiresKey = true;
    }

    public boolean hasKey() {
        return !TextUtils.isEmpty((CharSequence)this.mKey);
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    protected boolean shouldPersist() {
        return this.mPreferenceManager != null && this.isPersistent() && this.hasKey();
    }

    public void setPersistent(boolean persistent) {
        this.mPersistent = persistent;
    }

    public void setSingleLineTitle(boolean singleLineTitle) {
        this.mHasSingleLineTitleAttr = true;
        this.mSingleLineTitle = singleLineTitle;
    }

    public boolean isSingleLineTitle() {
        return this.mSingleLineTitle;
    }

    public void setIconSpaceReserved(boolean iconSpaceReserved) {
        this.mIconSpaceReserved = iconSpaceReserved;
        this.notifyChanged();
    }

    public boolean isIconSpaceReserved() {
        return this.mIconSpaceReserved;
    }

    public boolean callChangeListener(Object newValue) {
        return this.mOnChangeListener == null || this.mOnChangeListener.onPreferenceChange(this, newValue);
    }

    public void setOnPreferenceChangeListener(OnPreferenceChangeListener onPreferenceChangeListener) {
        this.mOnChangeListener = onPreferenceChangeListener;
    }

    public OnPreferenceChangeListener getOnPreferenceChangeListener() {
        return this.mOnChangeListener;
    }

    public void setOnPreferenceClickListener(OnPreferenceClickListener onPreferenceClickListener) {
        this.mOnClickListener = onPreferenceClickListener;
    }

    public OnPreferenceClickListener getOnPreferenceClickListener() {
        return this.mOnClickListener;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void performClick(View view) {
        this.performClick();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void performClick() {
        PreferenceManager.OnPreferenceTreeClickListener listener;
        if (!this.isEnabled()) {
            return;
        }
        this.onClick();
        if (this.mOnClickListener != null && this.mOnClickListener.onPreferenceClick(this)) {
            return;
        }
        PreferenceManager preferenceManager = this.getPreferenceManager();
        if (preferenceManager != null && (listener = preferenceManager.getOnPreferenceTreeClickListener()) != null && listener.onPreferenceTreeClick(this)) {
            return;
        }
        if (this.mIntent != null) {
            Context context = this.getContext();
            if (this.mIntent.resolveActivity(context.getPackageManager()) != null) {
                try {
                    context.startActivity(this.mIntent);
                }
                catch (Exception e) {
                    Log.w((String)"Preference", (String)("can't start intent " + this.mIntent), (Throwable)e);
                }
            } else {
                Log.w((String)"Preference", (String)("can't start intent " + this.mIntent + " because no matching activity found"));
            }
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mPreferenceManager == null || this.getPreferenceDataStore() != null) {
            return null;
        }
        return this.mPreferenceManager.getSharedPreferences();
    }

    @Override
    public int compareTo(@NonNull Preference another) {
        if (this.mOrder != another.mOrder) {
            return this.mOrder - another.mOrder;
        }
        if (this.mTitle == another.mTitle) {
            return 0;
        }
        if (this.mTitle == null) {
            return 1;
        }
        if (another.mTitle == null) {
            return -1;
        }
        return this.mTitle.toString().compareToIgnoreCase(another.mTitle.toString());
    }

    final void setOnPreferenceChangeInternalListener(OnPreferenceChangeInternalListener listener) {
        this.mListener = listener;
    }

    protected void notifyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceChange(this);
        }
    }

    protected void notifyHierarchyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceHierarchyChange(this);
        }
    }

    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    protected void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        if (!this.mHasId) {
            this.mId = preferenceManager.getNextId();
        }
        this.dispatchSetInitialValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onAttachedToHierarchy(PreferenceManager preferenceManager, long id2) {
        this.mId = id2;
        this.mHasId = true;
        try {
            this.onAttachedToHierarchy(preferenceManager);
        }
        finally {
            this.mHasId = false;
        }
    }

    void assignParent(@Nullable PreferenceGroup parentGroup) {
        this.mParentGroup = parentGroup;
    }

    public void onAttached() {
        this.registerDependency();
    }

    public void onDetached() {
        this.unregisterDependency();
        this.mWasDetached = true;
    }

    public final boolean wasDetached() {
        return this.mWasDetached;
    }

    public final void clearWasDetached() {
        this.mWasDetached = false;
    }

    private void registerDependency() {
        if (TextUtils.isEmpty((CharSequence)this.mDependencyKey)) {
            return;
        }
        Preference preference = this.findPreferenceInHierarchy(this.mDependencyKey);
        if (preference == null) {
            throw new IllegalStateException("Dependency \"" + this.mDependencyKey + "\" not found for preference \"" + this.mKey + "\" (title: \"" + this.mTitle + "\"");
        }
        preference.registerDependent(this);
    }

    private void unregisterDependency() {
        Preference oldDependency;
        if (this.mDependencyKey != null && (oldDependency = this.findPreferenceInHierarchy(this.mDependencyKey)) != null) {
            oldDependency.unregisterDependent(this);
        }
    }

    protected Preference findPreferenceInHierarchy(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(key);
    }

    private void registerDependent(Preference dependent) {
        if (this.mDependents == null) {
            this.mDependents = new ArrayList<Preference>();
        }
        this.mDependents.add(dependent);
        dependent.onDependencyChanged(this, this.shouldDisableDependents());
    }

    private void unregisterDependent(Preference dependent) {
        if (this.mDependents != null) {
            this.mDependents.remove(dependent);
        }
    }

    public void notifyDependencyChange(boolean disableDependents) {
        List<Preference> dependents = this.mDependents;
        if (dependents == null) {
            return;
        }
        int dependentsCount = dependents.size();
        for (int i = 0; i < dependentsCount; ++i) {
            dependents.get(i).onDependencyChanged(this, disableDependents);
        }
    }

    public void onDependencyChanged(Preference dependency, boolean disableDependent) {
        if (this.mDependencyMet == disableDependent) {
            this.mDependencyMet = !disableDependent;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    public void onParentChanged(Preference parent, boolean disableChild) {
        if (this.mParentDependencyMet == disableChild) {
            this.mParentDependencyMet = !disableChild;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    public boolean shouldDisableDependents() {
        return !this.isEnabled();
    }

    public void setDependency(String dependencyKey) {
        this.unregisterDependency();
        this.mDependencyKey = dependencyKey;
        this.registerDependency();
    }

    public String getDependency() {
        return this.mDependencyKey;
    }

    @Nullable
    public PreferenceGroup getParent() {
        return this.mParentGroup;
    }

    protected void onPrepareForRemoval() {
        this.unregisterDependency();
    }

    public void setDefaultValue(Object defaultValue) {
        this.mDefaultValue = defaultValue;
    }

    private void dispatchSetInitialValue() {
        if (this.getPreferenceDataStore() != null) {
            this.onSetInitialValue(true, this.mDefaultValue);
            return;
        }
        boolean shouldPersist = this.shouldPersist();
        if (!shouldPersist || !this.getSharedPreferences().contains(this.mKey)) {
            if (this.mDefaultValue != null) {
                this.onSetInitialValue(false, this.mDefaultValue);
            }
        } else {
            this.onSetInitialValue(true, null);
        }
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
    }

    public int getDividerBelowVisibility() {
        return this.mDividerBelowVisibility;
    }

    public void setDividerBelowVisibility(int dividerBelowVisibility) {
        this.mDividerBelowVisibility = dividerBelowVisibility;
    }

    private void tryCommit(@NonNull SharedPreferences.Editor editor) {
        if (this.mPreferenceManager.shouldCommit()) {
            SharedPreferencesCompat.EditorCompat.getInstance().apply(editor);
        }
    }

    protected boolean persistString(String value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (TextUtils.equals((CharSequence)value, (CharSequence)this.getPersistedString(null))) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putString(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putString(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    protected String getPersistedString(String defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getString(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getString(this.mKey, defaultReturnValue);
    }

    public boolean persistStringSet(Set<String> values) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (values.equals(this.getPersistedStringSet(null))) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putStringSet(this.mKey, values);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putStringSet(this.mKey, values);
            this.tryCommit(editor);
        }
        return true;
    }

    public Set<String> getPersistedStringSet(Set<String> defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getStringSet(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getStringSet(this.mKey, defaultReturnValue);
    }

    protected boolean persistInt(int value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (value == this.getPersistedInt(~value)) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putInt(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putInt(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    protected int getPersistedInt(int defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getInt(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getInt(this.mKey, defaultReturnValue);
    }

    protected boolean persistFloat(float value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (value == this.getPersistedFloat(Float.NaN)) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putFloat(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putFloat(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    protected float getPersistedFloat(float defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getFloat(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getFloat(this.mKey, defaultReturnValue);
    }

    protected boolean persistLong(long value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (value == this.getPersistedLong(value ^ 0xFFFFFFFFFFFFFFFFL)) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putLong(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putLong(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    protected long getPersistedLong(long defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getLong(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getLong(this.mKey, defaultReturnValue);
    }

    protected boolean persistBoolean(boolean value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (value == this.getPersistedBoolean(!value)) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putBoolean(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putBoolean(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    protected boolean getPersistedBoolean(boolean defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getBoolean(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getBoolean(this.mKey, defaultReturnValue);
    }

    public String toString() {
        return this.getFilterableStringBuilder().toString();
    }

    StringBuilder getFilterableStringBuilder() {
        CharSequence summary;
        StringBuilder sb = new StringBuilder();
        CharSequence title = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            sb.append(title).append(' ');
        }
        if (!TextUtils.isEmpty((CharSequence)(summary = this.getSummary()))) {
            sb.append(summary).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    public void saveHierarchyState(Bundle container) {
        this.dispatchSaveInstanceState(container);
    }

    void dispatchSaveInstanceState(Bundle container) {
        if (this.hasKey()) {
            this.mBaseMethodCalled = false;
            Parcelable state = this.onSaveInstanceState();
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onSaveInstanceState()");
            }
            if (state != null) {
                container.putParcelable(this.mKey, state);
            }
        }
    }

    protected Parcelable onSaveInstanceState() {
        this.mBaseMethodCalled = true;
        return BaseSavedState.EMPTY_STATE;
    }

    public void restoreHierarchyState(Bundle container) {
        this.dispatchRestoreInstanceState(container);
    }

    void dispatchRestoreInstanceState(Bundle container) {
        Parcelable state;
        if (this.hasKey() && (state = container.getParcelable(this.mKey)) != null) {
            this.mBaseMethodCalled = false;
            this.onRestoreInstanceState(state);
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onRestoreInstanceState()");
            }
        }
    }

    protected void onRestoreInstanceState(Parcelable state) {
        this.mBaseMethodCalled = true;
        if (state != BaseSavedState.EMPTY_STATE && state != null) {
            throw new IllegalArgumentException("Wrong state class -- expecting Preference State");
        }
    }

    @CallSuper
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfoCompat info) {
    }

    public static class BaseSavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<BaseSavedState> CREATOR = new Parcelable.Creator<BaseSavedState>(){

            public BaseSavedState createFromParcel(Parcel in) {
                return new BaseSavedState(in);
            }

            public BaseSavedState[] newArray(int size) {
                return new BaseSavedState[size];
            }
        };

        public BaseSavedState(Parcel source) {
            super(source);
        }

        public BaseSavedState(Parcelable superState) {
            super(superState);
        }
    }

    static interface OnPreferenceChangeInternalListener {
        public void onPreferenceChange(Preference var1);

        public void onPreferenceHierarchyChange(Preference var1);

        public void onPreferenceVisibilityChange(Preference var1);
    }

    public static interface OnPreferenceClickListener {
        public boolean onPreferenceClick(Preference var1);
    }

    public static interface OnPreferenceChangeListener {
        public boolean onPreferenceChange(Preference var1, Object var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerVisibility {
        public static final int UNSPECIFIED = 0;
        public static final int ENFORCED = 1;
        public static final int FORBIDDEN = 2;
    }
}

