/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.widget.Checkable;
import android.widget.CompoundButton;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.TypedArrayUtils;
import moe.shizuku.preference.PreferenceViewHolder;
import moe.shizuku.preference.R;
import moe.shizuku.preference.TwoStatePreference;

public class CheckBoxPreference
extends TwoStatePreference {
    private final Listener mListener = new Listener();

    public CheckBoxPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Preference_CheckBoxPreference_Material);
    }

    @SuppressLint(value={"RestrictedApi"})
    public CheckBoxPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CheckBoxPreference, defStyleAttr, defStyleRes);
        this.setSummaryOn(TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.CheckBoxPreference_summaryOn, (int)R.styleable.CheckBoxPreference_android_summaryOn));
        this.setSummaryOff(TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.CheckBoxPreference_summaryOff, (int)R.styleable.CheckBoxPreference_android_summaryOff));
        this.setDisableDependentsState(TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.CheckBoxPreference_disableDependentsState, (int)R.styleable.CheckBoxPreference_android_disableDependentsState, (boolean)false));
        a.recycle();
    }

    public CheckBoxPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.checkBoxPreferenceStyle);
    }

    public CheckBoxPreference(Context context) {
        this(context, null);
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.syncCheckboxView(holder.findViewById(R.id.checkbox));
        this.syncSummaryView(holder);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void performClick(View view) {
        super.performClick(view);
        this.syncViewIfAccessibilityEnabled(view);
    }

    private void syncViewIfAccessibilityEnabled(View view) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        if (!accessibilityManager.isEnabled()) {
            return;
        }
        View checkboxView = view.findViewById(0x1020001);
        this.syncCheckboxView(checkboxView);
        View summaryView = view.findViewById(0x1020010);
        this.syncSummaryView(summaryView);
    }

    private void syncCheckboxView(View view) {
        if (view instanceof CompoundButton) {
            ((CompoundButton)view).setOnCheckedChangeListener(null);
        }
        if (view instanceof Checkable) {
            ((Checkable)view).setChecked(this.mChecked);
        }
        if (view instanceof CompoundButton) {
            ((CompoundButton)view).setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this.mListener);
        }
    }

    private class Listener
    implements CompoundButton.OnCheckedChangeListener {
        private Listener() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (!CheckBoxPreference.this.callChangeListener(isChecked)) {
                buttonView.setChecked(!isChecked);
                return;
            }
            CheckBoxPreference.this.setChecked(isChecked);
        }
    }
}

