/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider.compat;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.annotation.Nullable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import moe.shizuku.fontprovider.compat.FontFamilyImpl;
import moe.shizuku.fontprovider.compat.FontFamilyImpl21;
import moe.shizuku.fontprovider.compat.FontFamilyImpl24;
import moe.shizuku.fontprovider.compat.FontFamilyImpl26;

@SuppressLint(value={"PrivateApi"})
public class FontFamilyCompat {
    private static Class<?> cls;
    private static FontFamilyImpl sImpl;
    private Object mFontFamily;

    public static Class<?> getFontFamilyClass() {
        return cls;
    }

    public static Class<?> getFontFamilyArrayClass() {
        return Array.newInstance(cls, 0).getClass();
    }

    private static FontFamilyImpl getImpl() {
        if (sImpl != null) {
            return sImpl;
        }
        sImpl = Build.VERSION.SDK_INT >= 26 ? new FontFamilyImpl26() : (Build.VERSION.SDK_INT >= 24 ? new FontFamilyImpl24() : new FontFamilyImpl21());
        return sImpl;
    }

    public FontFamilyCompat(String lang, int variant) {
        this(FontFamilyCompat.getImpl().create(lang, variant));
    }

    private FontFamilyCompat(Object fontFamily) {
        this.mFontFamily = fontFamily;
    }

    @Nullable
    public Object getFontFamily() {
        return this.mFontFamily;
    }

    public boolean addFont(ByteBuffer font, int ttcIndex, int weight, int italic) {
        return FontFamilyCompat.getImpl().addFont(this.getFontFamily(), font, ttcIndex, weight, italic);
    }

    public boolean addFont(String path, int weight, int italic) {
        return FontFamilyCompat.getImpl().addFont(this.getFontFamily(), path, weight, italic);
    }

    public boolean freeze() {
        return FontFamilyCompat.getImpl().freeze(this.getFontFamily());
    }

    static {
        try {
            cls = Class.forName("android.graphics.FontFamily");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

