/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public class FontRequest
implements Parcelable {
    public static final FontRequest DEFAULT = new FontRequest();
    public static final FontRequest NOTO_COLOR_EMOJI = new FontRequest("Noto Color Emoji", 1);
    public static final FontRequest NOTO_COLOR_EMOJI_NOUGAT = new FontRequest("Noto Color Emoji", 2);
    public static final FontRequest NOTO_SERIF = new FontRequest("Noto Serif", 400, 700);
    public final String name;
    public final int[] weight;
    public static final Parcelable.Creator<FontRequest> CREATOR = new Parcelable.Creator<FontRequest>(){

        public FontRequest createFromParcel(Parcel source) {
            return new FontRequest(source);
        }

        public FontRequest[] newArray(int size) {
            return new FontRequest[size];
        }
    };

    public static FontRequest[] combine(FontRequest[] ... arrays) {
        int length = 0;
        for (FontRequest[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        FontRequest[] result = new FontRequest[length];
        length = 0;
        for (FontRequest[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    private FontRequest() {
        this(null, (int[])null);
    }

    public FontRequest(String name, int ... weight) {
        this.name = name;
        this.weight = weight;
    }

    public String toString() {
        return "FontRequest{name='" + this.name + '\'' + ", weight=" + Arrays.toString(this.weight) + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeIntArray(this.weight);
    }

    protected FontRequest(Parcel in) {
        this.name = in.readString();
        this.weight = in.createIntArray();
    }
}

