/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider.compat;

import android.annotation.SuppressLint;
import android.graphics.Typeface;
import android.os.Build;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import moe.shizuku.fontprovider.compat.FontFamilyCompat;
import moe.shizuku.fontprovider.compat.TypefaceCompatApi21;
import moe.shizuku.fontprovider.compat.TypefaceCompatApi26;

@SuppressLint(value={"PrivateApi"})
public class TypefaceCompat {
    private static boolean available = true;
    private static Field sFallbackFontsField;
    private static Field sSystemFontMapField;
    private static Method createFromFamiliesMethod;
    private static Method setDefaultMethod;
    private static Method nativeCreateWeightAliasMethod;
    private static Constructor constructor;
    private static Field nativeInstanceField;
    private static Map<String, Typeface> sSystemFontMap;

    public static Object getFallbackFontsArray() {
        if (!available) {
            return null;
        }
        try {
            return sFallbackFontsField.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setFallbackFontsArray(Object array) {
        if (!available) {
            return;
        }
        try {
            sFallbackFontsField.set(null, array);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Typeface> getSystemFontMap() {
        if (!available) {
            return null;
        }
        if (sSystemFontMap == null) {
            try {
                sSystemFontMap = (Map)sSystemFontMapField.get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }
        return sSystemFontMap;
    }

    public static void setDefault(Typeface typeface) {
        if (!available) {
            return;
        }
        try {
            setDefaultMethod.invoke(null, typeface);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static long nativeCreateWeightAlias(long native_instance, int weight) {
        if (!available) {
            return -1L;
        }
        try {
            return (Long)nativeCreateWeightAliasMethod.invoke(null, native_instance, weight);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static Typeface create(long ni) {
        if (!available) {
            return null;
        }
        try {
            return (Typeface)constructor.newInstance(ni);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Typeface createWeightAlias(Typeface family, int weight) {
        if (!available) {
            return family;
        }
        try {
            return (Typeface)constructor.newInstance(TypefaceCompat.nativeCreateWeightAlias(TypefaceCompat.getNativeInstance(family), weight));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return family;
        }
    }

    public static Typeface createFromFamilies(Object families) {
        if (!available) {
            return null;
        }
        try {
            return (Typeface)createFromFamiliesMethod.invoke(null, families);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Typeface createFromFamiliesWithDefault(Object families, int weight, int italic) {
        if (Build.VERSION.SDK_INT >= 26) {
            return TypefaceCompatApi26.createFromFamiliesWithDefault(families, weight, italic);
        }
        return TypefaceCompatApi21.createFromFamiliesWithDefault(families);
    }

    public static long getNativeInstance(Typeface typeface) throws IllegalAccessException {
        return (Long)nativeInstanceField.get(typeface);
    }

    static {
        try {
            sFallbackFontsField = Typeface.class.getDeclaredField("sFallbackFonts");
            sFallbackFontsField.setAccessible(true);
            sSystemFontMapField = Typeface.class.getDeclaredField("sSystemFontMap");
            sSystemFontMapField.setAccessible(true);
            createFromFamiliesMethod = Typeface.class.getDeclaredMethod("createFromFamilies", FontFamilyCompat.getFontFamilyArrayClass());
            createFromFamiliesMethod.setAccessible(true);
            setDefaultMethod = Typeface.class.getDeclaredMethod("setDefault", Typeface.class);
            setDefaultMethod.setAccessible(true);
            nativeCreateWeightAliasMethod = Typeface.class.getDeclaredMethod("nativeCreateWeightAlias", Long.TYPE, Integer.TYPE);
            nativeCreateWeightAliasMethod.setAccessible(true);
            constructor = Typeface.class.getDeclaredConstructor(Long.TYPE);
            constructor.setAccessible(true);
            nativeInstanceField = Typeface.class.getDeclaredField("native_instance");
            nativeInstanceField.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
            available = false;
        }
    }
}

