/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import moe.shizuku.fontprovider.FontRequest;
import moe.shizuku.fontprovider.font.BundledFontFamily;

public class FontRequests
implements Parcelable {
    public static FontRequest[] DEFAULT_SANS_SERIF_FONTS = new FontRequest[]{FontRequest.DEFAULT};
    public static FontRequest[] DEFAULT_SERIF_FONTS = new FontRequest[]{FontRequest.NOTO_SERIF};
    public final int[] weight;
    public final FontRequest[] requests;
    public static final Parcelable.Creator<FontRequests> CREATOR = new Parcelable.Creator<FontRequests>(){

        public FontRequests createFromParcel(Parcel source) {
            return new FontRequests(source);
        }

        public FontRequests[] newArray(int size) {
            return new FontRequests[size];
        }
    };

    private static FontRequest[] filterDefault(FontRequest[] requests) {
        ArrayList<FontRequest> list = new ArrayList<FontRequest>();
        for (FontRequest request : requests) {
            if (request.equals(FontRequest.DEFAULT)) continue;
            list.add(request);
        }
        return list.toArray(new FontRequest[list.size()]);
    }

    public boolean ignoreDefault() {
        for (FontRequest fontRequest : this.requests) {
            if (!fontRequest.equals(FontRequest.DEFAULT)) continue;
            return false;
        }
        return true;
    }

    public BundledFontFamily request(ContentResolver resolver) {
        Bundle data = new Bundle();
        data.setClassLoader(this.getClass().getClassLoader());
        data.putParcelable("data", (Parcelable)this);
        Bundle result = resolver.call(Uri.parse((String)"content://moe.shizuku.fontprovider"), "request", "bundled", data);
        if (result != null) {
            result.setClassLoader(this.getClass().getClassLoader());
            return (BundledFontFamily)result.getParcelable("data");
        }
        return null;
    }

    private static FontRequest[] getDefaultFont(boolean serif) {
        return serif ? DEFAULT_SERIF_FONTS : DEFAULT_SANS_SERIF_FONTS;
    }

    public static FontRequests create(FontRequest[] defaultFonts, String fontName, int ... weight) {
        return new FontRequests(weight, FontRequest.combine(defaultFonts, {new FontRequest(fontName, weight)}));
    }

    public FontRequests(int weight, FontRequest ... requests) {
        this(new int[]{weight}, requests);
    }

    public FontRequests(int[] weight, FontRequest ... requests) {
        this.weight = weight;
        this.requests = requests;
    }

    public String toString() {
        return "FontRequests{weight=" + this.weight + ", requests=" + Arrays.toString(this.requests) + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.weight);
        dest.writeTypedArray((Parcelable[])FontRequests.filterDefault(this.requests), flags);
    }

    protected FontRequests(Parcel in) {
        this.weight = in.createIntArray();
        this.requests = (FontRequest[])in.createTypedArray(FontRequest.CREATOR);
    }
}

