/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider.font;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import moe.shizuku.fontprovider.font.Font;

public class FontFamily
implements Parcelable {
    public final int variant;
    public final String language;
    public final Font[] fonts;
    public static final Parcelable.Creator<FontFamily> CREATOR = new Parcelable.Creator<FontFamily>(){

        public FontFamily createFromParcel(Parcel source) {
            return new FontFamily(source);
        }

        public FontFamily[] newArray(int size) {
            return new FontFamily[size];
        }
    };

    public static FontFamily[] combine(FontFamily first, FontFamily[] array) {
        if (array == null) {
            return new FontFamily[]{first};
        }
        FontFamily[] result = new FontFamily[array.length + 1];
        result[0] = first;
        System.arraycopy(array, 0, result, 1, array.length);
        return result;
    }

    public static FontFamily[] combine(FontFamily[] ... arrays) {
        int length = 0;
        for (FontFamily[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        FontFamily[] result = new FontFamily[length];
        length = 0;
        for (FontFamily[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static FontFamily[] createFromTtc(String filename, String[] languages) {
        return FontFamily.createFromTtc(filename, languages, null);
    }

    public static FontFamily[] createFromTtc(String filename, String[] languages, int weight) {
        return FontFamily.createFromTtc(filename, languages, null, weight, 0, false);
    }

    public static FontFamily[] createFromTtc(String filename, String[] languages, int[] ttcIndex) {
        return FontFamily.createFromTtc(filename, languages, ttcIndex, -1, 0, false);
    }

    public static FontFamily[] createFromTtc(String filename, String[] languages, int[] ttcIndex, int weight, int variant, boolean italic) {
        FontFamily[] fontFamilies = new FontFamily[languages.length];
        for (int i = 0; i < languages.length; ++i) {
            fontFamilies[i] = new FontFamily(languages[i], variant, new Font(filename, ttcIndex == null ? i : ttcIndex[i], weight, italic));
        }
        return fontFamilies;
    }

    public FontFamily(String language, Font ... fonts) {
        this(language, 0, fonts);
    }

    public FontFamily(String language, int variant, Font ... fonts) {
        this.language = language;
        this.variant = variant;
        this.fonts = fonts;
    }

    public String toString() {
        return "FontFamily{variant=" + this.variant + ", language='" + this.language + '\'' + ", fonts=" + Arrays.toString(this.fonts) + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.variant);
        dest.writeString(this.language);
        dest.writeTypedArray((Parcelable[])this.fonts, flags);
    }

    protected FontFamily(Parcel in) {
        this.variant = in.readInt();
        this.language = in.readString();
        this.fonts = (Font[])in.createTypedArray(Font.CREATOR);
    }
}

