/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import moe.shizuku.fontprovider.FontProviderServiceConnection;
import moe.shizuku.fontprovider.FontRequest;
import moe.shizuku.fontprovider.FontRequests;
import moe.shizuku.fontprovider.IFontProvider;
import moe.shizuku.fontprovider.compat.FontFamilyCompat;
import moe.shizuku.fontprovider.compat.TypefaceCompat;
import moe.shizuku.fontprovider.font.Font;
import moe.shizuku.fontprovider.font.FontFamily;

public class FontProviderClient {
    private static final String TAG = "FontProviderClient";
    private static final String ACTION = "moe.shizuku.fontprovider.action.BIND";
    private static final String PACKAGE = "moe.shizuku.fontprovider";
    private static Map<String, ByteBuffer> sBufferCache = new HashMap<String, ByteBuffer>();
    private final boolean mUseContentProvider;
    private ContentResolver mResolver;
    private IFontProvider mFontProvider;

    public static void create(Context context, Callback callback) {
        context = context.getApplicationContext();
        Intent intent = new Intent(ACTION).setPackage(PACKAGE);
        sBufferCache.clear();
        try {
            FontProviderServiceConnection connection = new FontProviderServiceConnection(context, callback);
            context.bindService(intent, (ServiceConnection)connection, 1);
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"can't bindService", (Throwable)e);
        }
    }

    public static FontProviderClient createSync(Context context) {
        context = context.getApplicationContext();
        sBufferCache.clear();
        return new FontProviderClient(context);
    }

    private FontProviderClient(Context context) {
        this.mResolver = context.getContentResolver();
        this.mUseContentProvider = true;
    }

    FontProviderClient(Context context, IFontProvider fontProvider) {
        this.mResolver = context.getContentResolver();
        this.mFontProvider = fontProvider;
        this.mUseContentProvider = false;
    }

    public Typeface replace(String name, String fontName) {
        return this.replace(name, FontRequests.create(name, fontName));
    }

    public Typeface replace(String name, FontRequests fontRequests) {
        Typeface typeface = this.request(fontRequests);
        if (typeface != null && TypefaceCompat.getSystemFontMap() != null) {
            TypefaceCompat.getSystemFontMap().put(name, typeface);
            return typeface;
        }
        return null;
    }

    public Typeface request(FontRequests fontRequests) {
        boolean ignoreDefault = true;
        FontFamily[] fontFamilies = new FontFamily[]{};
        for (FontRequest fontRequest : fontRequests.requests) {
            if (fontRequest.equals(FontRequest.DEFAULT)) {
                ignoreDefault = false;
                continue;
            }
            try {
                long time = System.currentTimeMillis();
                fontFamilies = !this.mUseContentProvider ? FontFamily.combine(fontFamilies, fontRequest.loadFontFamily(this.mFontProvider)) : FontFamily.combine(fontFamilies, fontRequest.loadFontFamily(this.mResolver));
                Log.d((String)TAG, (String)("get info for " + fontRequest.name + " costs " + (System.currentTimeMillis() - time) + "ms"));
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return null;
            }
        }
        Object families = !ignoreDefault ? Array.newInstance(FontFamilyCompat.getFontFamilyClass(), fontFamilies.length + 1) : Array.newInstance(FontFamilyCompat.getFontFamilyClass(), fontFamilies.length);
        int i = 0;
        Object fallbackFonts = TypefaceCompat.getFallbackFontsArray();
        if (fallbackFonts == null || Array.getLength(fallbackFonts) == 0) {
            return null;
        }
        if (!ignoreDefault) {
            Array.set(families, i++, Array.get(fallbackFonts, 0));
        }
        for (FontFamily fontFamily : fontFamilies) {
            FontFamilyCompat fontFamilyCompat = new FontFamilyCompat(fontFamily.language, fontFamily.variant);
            if (fontFamilyCompat.getFontFamily() == null) {
                return null;
            }
            for (Font font : fontFamily.fonts) {
                try {
                    if (Build.VERSION.SDK_INT >= 24) {
                        ByteBuffer byteBuffer;
                        ByteBuffer byteBuffer2 = byteBuffer = font.buffer != null ? font.buffer : sBufferCache.get(font.filename);
                        if (byteBuffer == null) {
                            int size;
                            ParcelFileDescriptor pfd;
                            long time = System.currentTimeMillis();
                            if (!this.mUseContentProvider) {
                                pfd = this.mFontProvider.getFontFileDescriptor(font.filename);
                                size = this.mFontProvider.getFontFileSize(font.filename);
                            } else {
                                pfd = this.mResolver.openAssetFileDescriptor(Uri.parse((String)("content://moe.shizuku.fontprovider/file/" + font.filename)), "r").getParcelFileDescriptor();
                                size = (int)font.size;
                            }
                            Log.d((String)TAG, (String)("open file " + font.filename + " costs " + (System.currentTimeMillis() - time) + "ms"));
                            if (pfd == null) {
                                Log.e((String)TAG, (String)"ParcelFileDescriptor is null");
                                return null;
                            }
                            FileInputStream is = new FileInputStream(pfd.getFileDescriptor());
                            FileChannel fileChannel = is.getChannel();
                            byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                            sBufferCache.put(font.filename, byteBuffer);
                        }
                        if (fontFamilyCompat.addFont(byteBuffer, font.ttcIndex, font.weight, font.italic ? 1 : 0)) continue;
                        return null;
                    }
                    String path = !this.mUseContentProvider ? this.mFontProvider.getFontFilePath(font.filename) : font.path;
                    if (path == null) {
                        Log.e((String)TAG, (String)("Font " + font.filename + " not downloaded?"));
                        return null;
                    }
                    if (fontFamilyCompat.addFont(path, font.weight, font.italic ? 1 : 0)) continue;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!fontFamilyCompat.freeze()) {
                return null;
            }
            Array.set(families, i++, fontFamilyCompat.getFontFamily());
        }
        return TypefaceCompat.createFromFamiliesWithDefault(families, fontRequests.weight[0], -1);
    }

    public static interface Callback {
        public boolean onServiceConnected(FontProviderClient var1, ServiceConnection var2);
    }
}

