/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider.font;

import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;

public class Font
implements Parcelable {
    public final String filename;
    public final ByteBuffer buffer;
    public final int ttcIndex;
    public final int weight;
    public final boolean italic;
    public static final Parcelable.Creator<Font> CREATOR = new Parcelable.Creator<Font>(){

        public Font createFromParcel(Parcel source) {
            return new Font(source);
        }

        public Font[] newArray(int size) {
            return new Font[size];
        }
    };

    public Font(String filename) {
        this(filename, false);
    }

    public Font(String filename, boolean italic) {
        this(filename, 0, -1, italic);
    }

    public Font(ByteBuffer buffer, int ttcIndex, int weight, boolean italic) {
        this(null, buffer, ttcIndex, weight, italic);
    }

    public Font(String filename, int ttcIndex, int weight, boolean italic) {
        this(filename, null, ttcIndex, weight, italic);
    }

    public Font(String filename, ByteBuffer buffer, int ttcIndex, int weight, boolean italic) {
        this.buffer = buffer;
        this.filename = filename;
        this.ttcIndex = ttcIndex;
        this.weight = weight;
        this.italic = italic;
    }

    public String toString() {
        return "Font{filename='" + this.filename + '\'' + ", ttcIndex=" + this.ttcIndex + ", weight=" + this.weight + ", italic=" + this.italic + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.filename);
        dest.writeInt(this.ttcIndex);
        dest.writeInt(this.weight);
        dest.writeByte(this.italic ? (byte)1 : 0);
    }

    protected Font(Parcel in) {
        this.filename = in.readString();
        this.buffer = null;
        this.ttcIndex = in.readInt();
        this.weight = in.readInt();
        this.italic = in.readByte() != 0;
    }
}

