/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import moe.shizuku.fontprovider.IFontProvider;
import moe.shizuku.fontprovider.api.TypefaceReplacer;

class FontProviderServiceConnection
implements ServiceConnection {
    private static final String TAG = "FontProviderServiceConnection";
    private Context mContext;
    private TypefaceReplacer.FontRequest[] mFontRequests;

    FontProviderServiceConnection(Context context, TypefaceReplacer.FontRequest[] fontRequests) {
        this.mContext = context;
        this.mFontRequests = fontRequests;
    }

    public void onServiceConnected(ComponentName componentName, IBinder binder) {
        IFontProvider fontProvider = IFontProvider.Stub.asInterface(binder);
        for (TypefaceReplacer.FontRequest request : this.mFontRequests) {
            boolean succeed = TypefaceReplacer.request(fontProvider, request);
            if (succeed) {
                Log.i((String)TAG, (String)("succeed: " + request.toString()));
                continue;
            }
            Log.w((String)TAG, (String)("failed: " + request.toString()));
        }
        this.unbind();
    }

    public void onServiceDisconnected(ComponentName componentName) {
    }

    void unbind() {
        if (this.mContext != null) {
            try {
                this.mContext.unbindService((ServiceConnection)this);
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.w((String)TAG, (String)"failed to unbindService");
            }
        }
    }
}

