/*
 * Decompiled with CFR 0.152.
 */
package moe.feng.common.stepperview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import moe.feng.common.stepperview.IStepperAdapter;
import moe.feng.common.stepperview.IStepperView;
import moe.feng.common.stepperview.R;
import moe.feng.common.stepperview.VerticalStepperItemView;
import moe.feng.common.stepperview.internal.VerticalSpaceItemDecoration;

public class VerticalStepperView
extends FrameLayout
implements IStepperView {
    private RecyclerView mListView;
    private ItemAdapter mAdapter;
    private IStepperAdapter mStepperAdapter;
    private int mCurrentStep = 0;
    private CharSequence[] mErrorTexts = null;
    private boolean mAnimationEnabled;
    private int mAnimationDuration;
    private int mNormalColor;
    private int mActivatedColor;
    private int mLineColor;
    private int mErrorColor;
    private Drawable mDoneIcon;
    private boolean mAlwaysShowSummary = false;

    public VerticalStepperView(Context context) {
        this(context, null);
    }

    public VerticalStepperView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerticalStepperView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.prepareListView(context);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VerticalStepperView, defStyleAttr, R.style.Widget_Stepper);
            this.mNormalColor = a.getColor(R.styleable.VerticalStepperView_step_normal_color, this.mNormalColor);
            this.mActivatedColor = a.getColor(R.styleable.VerticalStepperView_step_activated_color, this.mActivatedColor);
            this.mAnimationDuration = a.getInt(R.styleable.VerticalStepperView_step_animation_duration, this.mAnimationDuration);
            this.mAnimationEnabled = a.getBoolean(R.styleable.VerticalStepperView_step_enable_animation, true);
            this.mLineColor = a.getColor(R.styleable.VerticalStepperView_step_line_color, this.mLineColor);
            this.mErrorColor = a.getColor(R.styleable.VerticalStepperView_step_error_highlight_color, this.mErrorColor);
            this.mAlwaysShowSummary = a.getBoolean(R.styleable.VerticalStepperView_step_show_summary_always, this.mAlwaysShowSummary);
            if (a.hasValue(R.styleable.VerticalStepperView_step_done_icon)) {
                this.mDoneIcon = a.getDrawable(R.styleable.VerticalStepperView_step_done_icon);
            }
            a.recycle();
        }
        this.setAnimationEnabled(this.mAnimationEnabled);
    }

    private void prepareListView(Context context) {
        this.mListView = new RecyclerView(context);
        this.mAdapter = new ItemAdapter();
        this.mListView.setClipToPadding(false);
        this.mListView.setPadding(0, this.getResources().getDimensionPixelSize(R.dimen.stepper_margin_top), 0, 0);
        this.mListView.addItemDecoration((RecyclerView.ItemDecoration)new VerticalSpaceItemDecoration(this.getResources().getDimensionPixelSize(R.dimen.vertical_stepper_item_space_height)));
        this.mListView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.mListView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.addView((View)this.mListView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void setStepperAdapter(IStepperAdapter stepperAdapter) {
        this.mStepperAdapter = stepperAdapter;
        this.updateSteppers();
    }

    public void updateSteppers() {
        if (this.mErrorTexts != null && this.mErrorTexts.length != this.mStepperAdapter.size() || this.mErrorTexts == null) {
            this.mErrorTexts = new String[this.mStepperAdapter.size()];
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void setAlwaysShowSummary(boolean alwaysShowSummary) {
        this.mAlwaysShowSummary = alwaysShowSummary;
        this.updateSteppers();
    }

    @Override
    public boolean isAlwaysShowSummary() {
        return this.mAlwaysShowSummary;
    }

    public void setErrorText(int index, @Nullable CharSequence errorText) {
        if (this.mErrorTexts == null) {
            this.mErrorTexts = new String[this.mStepperAdapter.size()];
        }
        this.mErrorTexts[index] = errorText;
        this.updateSteppers();
    }

    @Nullable
    public CharSequence getErrorText(int index) {
        if (this.mErrorTexts != null) {
            return this.mErrorTexts[index];
        }
        return null;
    }

    public int getStepCount() {
        return this.mStepperAdapter != null ? this.mStepperAdapter.size() : 0;
    }

    public boolean canNext() {
        return this.mStepperAdapter != null && this.mCurrentStep < this.mStepperAdapter.size() - 1;
    }

    public boolean canPrev() {
        return this.mStepperAdapter != null && this.mCurrentStep > 0;
    }

    public boolean nextStep() {
        if (this.canNext()) {
            this.mStepperAdapter.onHide(this.mCurrentStep);
            ++this.mCurrentStep;
            this.mStepperAdapter.onShow(this.mCurrentStep);
            if (this.mAnimationEnabled) {
                this.mAdapter.notifyItemRangeChanged(this.mCurrentStep - 1, 2);
            } else {
                this.mAdapter.notifyDataSetChanged();
            }
            return true;
        }
        return false;
    }

    public boolean prevStep() {
        if (this.canPrev()) {
            this.mStepperAdapter.onHide(this.mCurrentStep);
            --this.mCurrentStep;
            this.mStepperAdapter.onShow(this.mCurrentStep);
            if (this.mAnimationEnabled) {
                this.mAdapter.notifyItemRangeChanged(this.mCurrentStep, 2);
            } else {
                this.mAdapter.notifyDataSetChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    public IStepperAdapter getStepperAdapter() {
        return this.mStepperAdapter;
    }

    @Override
    public int getCurrentStep() {
        return this.mCurrentStep;
    }

    public void setNormalColor(@ColorInt int color) {
        this.mNormalColor = color;
        this.mAdapter.notifyDataSetChanged();
    }

    public void setNormalColorResource(@ColorRes int colorRes) {
        this.setNormalColor(this.getResources().getColor(colorRes));
    }

    @Override
    public int getNormalColor() {
        return this.mNormalColor;
    }

    public void setActivatedColor(@ColorInt int color) {
        this.mActivatedColor = color;
        this.mAdapter.notifyDataSetChanged();
    }

    public void setActivatedColorResource(@ColorRes int colorRes) {
        this.setActivatedColor(this.getResources().getColor(colorRes));
    }

    @Override
    public int getActivatedColor() {
        return this.mActivatedColor;
    }

    public void setErrorColor(@ColorInt int color) {
        this.mErrorColor = color;
        this.mAdapter.notifyDataSetChanged();
    }

    public void setErrorColorResource(@ColorRes int colorRes) {
        this.setErrorColor(this.getResources().getColor(colorRes));
    }

    @Override
    public int getErrorColor() {
        return this.mErrorColor;
    }

    public void setLineColor(@ColorInt int color) {
        this.mLineColor = color;
        this.mAdapter.notifyDataSetChanged();
    }

    public void setLineColorResource(@ColorRes int colorRes) {
        this.setLineColor(this.getResources().getColor(colorRes));
    }

    @Override
    public int getLineColor() {
        return this.mLineColor;
    }

    @Override
    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    @Override
    public Drawable getDoneIcon() {
        return this.mDoneIcon;
    }

    public void setAnimationEnabled(boolean enabled) {
        this.mAnimationEnabled = enabled;
    }

    public boolean isAnimationEnabled() {
        return this.mAnimationEnabled;
    }

    public void setCurrentStep(int currentStep) {
        int minIndex = Math.min(currentStep, this.mCurrentStep);
        int count = Math.abs(this.mCurrentStep - currentStep) + 1;
        this.mCurrentStep = currentStep;
        if (this.mAnimationEnabled) {
            this.mAdapter.notifyItemRangeChanged(minIndex, count);
        } else {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    class ItemAdapter
    extends RecyclerView.Adapter<ItemHolder> {
        ItemAdapter() {
        }

        public ItemHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new ItemHolder(new VerticalStepperItemView(parent.getContext()));
        }

        public void onBindViewHolder(ItemHolder holder, int position) {
            holder.mItemView.setIndex(position + 1);
            holder.mItemView.setIsLastStep(position == this.getItemCount() - 1);
            holder.mItemView.setTitle(VerticalStepperView.this.getStepperAdapter().getTitle(position));
            holder.mItemView.setSummary(VerticalStepperView.this.getStepperAdapter().getSummary(position));
            holder.mItemView.setNormalColor(VerticalStepperView.this.mNormalColor);
            holder.mItemView.setActivatedColor(VerticalStepperView.this.mActivatedColor);
            holder.mItemView.setAnimationDuration(VerticalStepperView.this.mAnimationDuration);
            holder.mItemView.setDoneIcon(VerticalStepperView.this.mDoneIcon);
            holder.mItemView.setAnimationEnabled(VerticalStepperView.this.mAnimationEnabled);
            holder.mItemView.setLineColor(VerticalStepperView.this.mLineColor);
            holder.mItemView.setErrorColor(VerticalStepperView.this.mErrorColor);
            holder.mItemView.setErrorText(VerticalStepperView.this.mErrorTexts[position]);
            holder.mItemView.setAlwaysShowSummary(VerticalStepperView.this.mAlwaysShowSummary);
            if (VerticalStepperView.this.getCurrentStep() > position) {
                holder.mItemView.setState(2);
            } else if (VerticalStepperView.this.getCurrentStep() < position) {
                holder.mItemView.setState(0);
            } else {
                holder.mItemView.setState(1);
            }
            holder.mItemView.removeCustomView();
            View customView = VerticalStepperView.this.getStepperAdapter().onCreateCustomView(position, VerticalStepperView.this.getContext(), holder.mItemView);
            if (customView != null) {
                holder.mItemView.addView(customView);
            }
        }

        public int getItemCount() {
            return VerticalStepperView.this.getStepCount();
        }

        class ItemHolder
        extends RecyclerView.ViewHolder {
            VerticalStepperItemView mItemView;

            ItemHolder(VerticalStepperItemView itemView) {
                super((View)itemView);
                this.mItemView = itemView;
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2);
                this.mItemView.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }
}

