/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import mil.nga.tiff.FieldTagType;
import mil.nga.tiff.FieldType;
import mil.nga.tiff.FileDirectory;
import mil.nga.tiff.FileDirectoryEntry;
import mil.nga.tiff.TIFFImage;
import mil.nga.tiff.io.ByteReader;
import mil.nga.tiff.io.IOUtils;
import mil.nga.tiff.util.TiffException;

public class TiffReader {
    public static TIFFImage readTiff(File file) throws IOException {
        return TiffReader.readTiff(file, false);
    }

    public static TIFFImage readTiff(File file, boolean cache) throws IOException {
        byte[] bytes = IOUtils.fileBytes(file);
        TIFFImage tiffImage = TiffReader.readTiff(bytes, cache);
        return tiffImage;
    }

    public static TIFFImage readTiff(InputStream stream) throws IOException {
        return TiffReader.readTiff(stream, false);
    }

    public static TIFFImage readTiff(InputStream stream, boolean cache) throws IOException {
        byte[] bytes = IOUtils.streamBytes(stream);
        TIFFImage tiffImage = TiffReader.readTiff(bytes, cache);
        return tiffImage;
    }

    public static TIFFImage readTiff(byte[] bytes) {
        return TiffReader.readTiff(bytes, false);
    }

    public static TIFFImage readTiff(byte[] bytes, boolean cache) {
        ByteReader reader = new ByteReader(bytes);
        TIFFImage tiffImage = TiffReader.readTiff(reader, cache);
        return tiffImage;
    }

    public static TIFFImage readTiff(ByteReader reader) {
        return TiffReader.readTiff(reader, false);
    }

    public static TIFFImage readTiff(ByteReader reader, boolean cache) {
        String byteOrderString = null;
        try {
            byteOrderString = reader.readString(2);
        }
        catch (UnsupportedEncodingException e) {
            throw new TiffException("Failed to read byte order", e);
        }
        ByteOrder byteOrder = null;
        switch (byteOrderString) {
            case "II": {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case "MM": {
                byteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            default: {
                throw new TiffException("Invalid byte order: " + byteOrderString);
            }
        }
        reader.setByteOrder(byteOrder);
        int tiffIdentifier = reader.readUnsignedShort();
        if (tiffIdentifier != 42) {
            throw new TiffException("Invalid file identifier, not a TIFF");
        }
        int byteOffset = (int)reader.readUnsignedInt();
        TIFFImage tiffImage = TiffReader.parseTIFFImage(reader, byteOffset, cache);
        return tiffImage;
    }

    private static TIFFImage parseTIFFImage(ByteReader reader, int byteOffset, boolean cache) {
        TIFFImage tiffImage = new TIFFImage();
        while (byteOffset != 0) {
            reader.setNextByte(byteOffset);
            TreeSet<FileDirectoryEntry> entries = new TreeSet<FileDirectoryEntry>();
            int numDirectoryEntries = reader.readUnsignedShort();
            for (int entryCount = 0; entryCount < numDirectoryEntries; entryCount = (int)((short)(entryCount + 1))) {
                int fieldTagValue = reader.readUnsignedShort();
                FieldTagType fieldTag = FieldTagType.getById(fieldTagValue);
                int fieldTypeValue = reader.readUnsignedShort();
                FieldType fieldType = FieldType.getFieldType(fieldTypeValue);
                long typeCount = reader.readUnsignedInt();
                int nextByte = reader.getNextByte();
                Object values = TiffReader.readFieldValues(reader, fieldTag, fieldType, typeCount);
                FileDirectoryEntry entry = new FileDirectoryEntry(fieldTag, fieldType, typeCount, values);
                entries.add(entry);
                reader.setNextByte(nextByte + 4);
            }
            FileDirectory fileDirectory = new FileDirectory(entries, reader, cache);
            tiffImage.add(fileDirectory);
            byteOffset = (int)reader.readUnsignedInt();
        }
        return tiffImage;
    }

    private static Object readFieldValues(ByteReader reader, FieldTagType fieldTag, FieldType fieldType, long typeCount) {
        if ((long)fieldType.getBytes() * typeCount > 4L) {
            int valueOffset = (int)reader.readUnsignedInt();
            reader.setNextByte(valueOffset);
        }
        List<Object> valuesList = TiffReader.getValues(reader, fieldType, typeCount);
        Object values = null;
        values = typeCount == 1L && !fieldTag.isArray() && fieldType != FieldType.RATIONAL && fieldType != FieldType.SRATIONAL ? valuesList.get(0) : valuesList;
        return values;
    }

    private static List<Object> getValues(ByteReader reader, FieldType fieldType, long typeCount) {
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        while ((long)i < typeCount) {
            switch (fieldType) {
                case ASCII: {
                    try {
                        values.add(reader.readString(1));
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new TiffException("Failed to read ASCII character", e);
                    }
                }
                case BYTE: 
                case UNDEFINED: {
                    values.add(reader.readUnsignedByte());
                    break;
                }
                case SBYTE: {
                    values.add(reader.readByte());
                    break;
                }
                case SHORT: {
                    values.add(reader.readUnsignedShort());
                    break;
                }
                case SSHORT: {
                    values.add(reader.readShort());
                    break;
                }
                case LONG: {
                    values.add(reader.readUnsignedInt());
                    break;
                }
                case SLONG: {
                    values.add(reader.readInt());
                    break;
                }
                case RATIONAL: {
                    values.add(reader.readUnsignedInt());
                    values.add(reader.readUnsignedInt());
                    break;
                }
                case SRATIONAL: {
                    values.add(reader.readInt());
                    values.add(reader.readInt());
                    break;
                }
                case FLOAT: {
                    values.add(Float.valueOf(reader.readFloat()));
                    break;
                }
                case DOUBLE: {
                    values.add(reader.readDouble());
                    break;
                }
                default: {
                    throw new TiffException("Invalid field type: " + (Object)((Object)fieldType));
                }
            }
            ++i;
        }
        if (fieldType == FieldType.ASCII) {
            ArrayList<String> stringValues = new ArrayList<String>();
            StringBuilder stringValue = new StringBuilder();
            for (Object e : values) {
                if (e == null) {
                    if (stringValue.length() <= 0) continue;
                    stringValues.add(stringValue.toString());
                    stringValue = new StringBuilder();
                    continue;
                }
                stringValue.append(e.toString());
            }
            values = stringValues;
        }
        return values;
    }
}

