/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util.sweep;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.LineString;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.util.GeometryUtils;
import mil.nga.sf.util.sweep.Event;
import mil.nga.sf.util.sweep.EventQueue;
import mil.nga.sf.util.sweep.EventType;
import mil.nga.sf.util.sweep.Segment;
import mil.nga.sf.util.sweep.SweepLine;

public class ShamosHoey {
    public static boolean simplePolygon(Polygon polygon) {
        return ShamosHoey.simplePolygon(polygon.getRings());
    }

    public static boolean simplePolygonPoints(List<Point> points) {
        LineString ring = new LineString();
        ring.setPoints(points);
        return ShamosHoey.simplePolygon(ring);
    }

    public static boolean simplePolygonRingPoints(List<List<Point>> pointRings) {
        ArrayList<LineString> rings = new ArrayList<LineString>();
        for (List<Point> points : pointRings) {
            LineString ring = new LineString();
            ring.setPoints(points);
            rings.add(ring);
        }
        return ShamosHoey.simplePolygon(rings);
    }

    public static boolean simplePolygon(LineString ring) {
        ArrayList<LineString> rings = new ArrayList<LineString>();
        rings.add(ring);
        return ShamosHoey.simplePolygon(rings);
    }

    public static boolean simplePolygon(List<LineString> rings) {
        boolean simple = !rings.isEmpty();
        ArrayList<LineString> ringCopies = new ArrayList<LineString>();
        for (int i = 0; i < rings.size(); ++i) {
            LineString ring = rings.get(i);
            LineString ringCopy = new LineString();
            ringCopy.setPoints(new ArrayList<Point>(ring.getPoints()));
            ringCopies.add(ringCopy);
            List<Point> ringCopyPoints = ringCopy.getPoints();
            if (ringCopyPoints.size() >= 3) {
                Point first = ringCopyPoints.get(0);
                Point last = ringCopyPoints.get(ringCopyPoints.size() - 1);
                if (first.getX() == last.getX() && first.getY() == last.getY()) {
                    ringCopyPoints.remove(ringCopyPoints.size() - 1);
                }
            }
            if (ringCopyPoints.size() < 3) {
                simple = false;
                break;
            }
            if (i <= 0) continue;
            Point firstPoint = ringCopyPoints.get(0);
            if (!GeometryUtils.pointInPolygon(firstPoint, rings.get(0))) {
                simple = false;
                break;
            }
            for (int j = 1; j < i; ++j) {
                List<Point> holePoints = rings.get(j).getPoints();
                if (!GeometryUtils.pointInPolygon(firstPoint, holePoints) && !GeometryUtils.pointInPolygon(holePoints.get(0), ringCopyPoints)) continue;
                simple = false;
                break;
            }
            if (!simple) break;
        }
        if (simple) {
            EventQueue eventQueue = new EventQueue(ringCopies);
            SweepLine sweepLine = new SweepLine(ringCopies);
            for (Event event : eventQueue) {
                Segment segment;
                if (event.getType() == EventType.LEFT) {
                    segment = sweepLine.add(event);
                    if (!sweepLine.intersect(segment, segment.getAbove()) && !sweepLine.intersect(segment, segment.getBelow())) continue;
                    simple = false;
                    break;
                }
                segment = sweepLine.find(event);
                if (sweepLine.intersect(segment.getAbove(), segment.getBelow())) {
                    simple = false;
                    break;
                }
                sweepLine.remove(segment);
            }
        }
        return simple;
    }
}

