/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.LineString;
import mil.nga.sf.Point;
import mil.nga.sf.util.GeometryUtils;
import mil.nga.sf.util.SFException;

public class Line
extends LineString {
    public Line() {
        this(false, false);
    }

    public Line(boolean hasZ, boolean hasM) {
        super(hasZ, hasM);
    }

    public Line(List<Point> points) {
        this(GeometryUtils.hasZ(points), GeometryUtils.hasM(points));
        this.setPoints(points);
    }

    public Line(Line line) {
        this(line.hasZ(), line.hasM());
        for (Point point : line.getPoints()) {
            this.addPoint((Point)point.copy());
        }
    }

    @Override
    public void setPoints(List<Point> points) {
        super.setPoints(points);
        if (this.numPoints() != 2) {
            throw new SFException("A line must have exactly 2 points.");
        }
    }

    @Override
    public Geometry copy() {
        return new Line(this);
    }
}

