/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Curve;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.Surface;
import mil.nga.sf.util.GeometryUtils;
import mil.nga.sf.util.SFException;

public class GeometryCollection<T extends Geometry>
extends Geometry {
    private List<T> geometries = new ArrayList<T>();

    public GeometryCollection() {
        this(false, false);
    }

    public GeometryCollection(boolean hasZ, boolean hasM) {
        super(GeometryType.GEOMETRYCOLLECTION, hasZ, hasM);
    }

    public GeometryCollection(List<T> geometries) {
        this(GeometryUtils.hasZ(geometries), GeometryUtils.hasM(geometries));
        this.setGeometries(geometries);
    }

    public GeometryCollection(T geometry) {
        this(((Geometry)geometry).hasZ(), ((Geometry)geometry).hasM());
        this.addGeometry(geometry);
    }

    public GeometryCollection(GeometryCollection<T> geometryCollection) {
        this(geometryCollection.hasZ(), geometryCollection.hasM());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            Geometry geometryCopy = geometry.copy();
            this.addGeometry(geometryCopy);
        }
    }

    protected GeometryCollection(GeometryType type, boolean hasZ, boolean hasM) {
        super(type, hasZ, hasM);
    }

    public List<T> getGeometries() {
        return this.geometries;
    }

    public void setGeometries(List<T> geometries) {
        this.geometries = geometries;
    }

    public void addGeometry(T geometry) {
        this.geometries.add(geometry);
    }

    public void addGeometries(List<T> geometries) {
        this.geometries.addAll(geometries);
    }

    public int numGeometries() {
        return this.geometries.size();
    }

    public T getGeometry(int n) {
        return (T)((Geometry)this.geometries.get(n));
    }

    public GeometryType getCollectionType() {
        GeometryType geometryType = this.getGeometryType();
        switch (geometryType) {
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                if (this.isMultiPoint()) {
                    geometryType = GeometryType.MULTIPOINT;
                    break;
                }
                if (this.isMultiLineString()) {
                    geometryType = GeometryType.MULTILINESTRING;
                    break;
                }
                if (this.isMultiPolygon()) {
                    geometryType = GeometryType.MULTIPOLYGON;
                    break;
                }
                if (this.isMultiCurve()) {
                    geometryType = GeometryType.MULTICURVE;
                    break;
                }
                if (!this.isMultiSurface()) break;
                geometryType = GeometryType.MULTISURFACE;
                break;
            }
            default: {
                throw new SFException("Unexpected Geometry Collection Type: " + (Object)((Object)geometryType));
            }
        }
        return geometryType;
    }

    public boolean isMultiPoint() {
        boolean isMultiPoint = this instanceof MultiPoint;
        if (!isMultiPoint) {
            isMultiPoint = this.isCollectionOfType(Point.class);
        }
        return isMultiPoint;
    }

    public MultiPoint getAsMultiPoint() {
        MultiPoint newMultiPoint;
        MultiPoint multiPoint = this instanceof MultiPoint ? (MultiPoint)this : (newMultiPoint = new MultiPoint(this.geometries));
        return multiPoint;
    }

    public boolean isMultiLineString() {
        boolean isMultiLineString = this instanceof MultiLineString;
        if (!isMultiLineString) {
            isMultiLineString = this.isCollectionOfType(LineString.class);
        }
        return isMultiLineString;
    }

    public MultiLineString getAsMultiLineString() {
        MultiLineString newMultiLineString;
        MultiLineString multiLineString = this instanceof MultiLineString ? (MultiLineString)this : (newMultiLineString = new MultiLineString(this.geometries));
        return multiLineString;
    }

    public boolean isMultiPolygon() {
        boolean isMultiPolygon = this instanceof MultiPolygon;
        if (!isMultiPolygon) {
            isMultiPolygon = this.isCollectionOfType(Polygon.class);
        }
        return isMultiPolygon;
    }

    public MultiPolygon getAsMultiPolygon() {
        MultiPolygon newMultiPolygon;
        MultiPolygon multiPolygon = this instanceof MultiPolygon ? (MultiPolygon)this : (newMultiPolygon = new MultiPolygon(this.geometries));
        return multiPolygon;
    }

    public boolean isMultiCurve() {
        boolean isMultiCurve = this instanceof MultiLineString;
        if (!isMultiCurve) {
            isMultiCurve = this.isCollectionOfType(Curve.class);
        }
        return isMultiCurve;
    }

    public GeometryCollection<Curve> getAsMultiCurve() {
        GeometryCollection<List<List<List<List<List<List<List<List<T>>>>>>>>> multiCurve;
        if (this instanceof MultiLineString) {
            GeometryCollection<List<List<List<List<List<List<List<List<T>>>>>>>>> castMultiCurve;
            multiCurve = castMultiCurve = new GeometryCollection<List<List<List<List<List<List<List<List<T>>>>>>>>>(this.getGeometries());
        } else {
            GeometryCollection<List<List<List<List<List<List<List<List<T>>>>>>>>> castMultiCurve = this;
            multiCurve = castMultiCurve;
            if (!multiCurve.isEmpty()) {
                Curve curve = (Curve)((Object)multiCurve.getGeometry(0));
            }
        }
        return multiCurve;
    }

    public boolean isMultiSurface() {
        boolean isMultiSurface = this instanceof MultiPolygon;
        if (!isMultiSurface) {
            isMultiSurface = this.isCollectionOfType(Surface.class);
        }
        return isMultiSurface;
    }

    public GeometryCollection<Surface> getAsMultiSurface() {
        GeometryCollection<List<List<List<List<List<List<List<List<T>>>>>>>>> multiSurface;
        if (this instanceof MultiPolygon) {
            GeometryCollection<List<List<List<List<List<List<List<List<T>>>>>>>>> castMultiSurface;
            multiSurface = castMultiSurface = new GeometryCollection<List<List<List<List<List<List<List<List<T>>>>>>>>>(this.getGeometries());
        } else {
            GeometryCollection<List<List<List<List<List<List<List<List<T>>>>>>>>> castMultiSurface = this;
            multiSurface = castMultiSurface;
            if (!multiSurface.isEmpty()) {
                Surface surface = (Surface)((Object)multiSurface.getGeometry(0));
            }
        }
        return multiSurface;
    }

    public GeometryCollection<Geometry> getAsGeometryCollection() {
        GeometryCollection<List<List<List<List<List<List<List<List<List<List<List<List<List<List<List<List<T>>>>>>>>>>>>>>>>> castGeometryCollection;
        GeometryCollection<List<List<List<List<List<List<List<List<List<List<List<List<List<List<List<List<T>>>>>>>>>>>>>>>>> geometryCollection = GeometryCollection.class.equals(this.getClass()) ? (castGeometryCollection = this) : (castGeometryCollection = new GeometryCollection<List<List<List<List<List<List<List<List<List<List<List<List<List<List<List<List<T>>>>>>>>>>>>>>>>>(this.getGeometries()));
        return geometryCollection;
    }

    private <TType extends Geometry> boolean isCollectionOfType(Class<TType> type) {
        boolean isType = true;
        for (Geometry geometry : this.geometries) {
            if (type.isAssignableFrom(geometry.getClass())) continue;
            isType = false;
            break;
        }
        return isType;
    }

    @Override
    public Geometry copy() {
        return new GeometryCollection<T>(this);
    }

    @Override
    public boolean isEmpty() {
        return this.geometries.isEmpty();
    }

    @Override
    public boolean isSimple() {
        throw new UnsupportedOperationException("Is Simple not implemented for " + this.getClass().getSimpleName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.geometries == null ? 0 : this.geometries.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryCollection other = (GeometryCollection)obj;
        return !(this.geometries == null ? other.geometries != null : !this.geometries.equals(other.geometries));
    }
}

